<?php
require_once 'includes/config.php';
require_login();

$user = get_logged_in_user();

// Get settings
$min_withdrawal = get_setting('min_withdrawal') ?: 400;
$withdrawal_fee = get_setting('withdrawal_fee') ?: 0;

// Get payment methods
$payment_methods = get_payment_methods('withdrawal');
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>উইথড্রয়াল - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="container mt-4">
        <!-- Balance Display -->
        <div class="dashboard-card text-center mb-4">
            <h4>আপনার বর্তমান ব্যালেন্স</h4>
            <div class="balance-amount"><?php echo format_currency($user['balance']); ?></div>
        </div>

        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h4><i class="fas fa-hand-holding-usd"></i> উত্তোলন ফর্ম</h4>
                    </div>
                    <div class="card-body">
                        <!-- Quick Amount Selection -->
                        <div class="mb-4">
                            <h5>দ্রুত পরিমান নির্বাচন:</h5>
                            <div class="row">
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="1000">১,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="5000">৫,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="10000">১০,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="20000">২০,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="25000">২৫,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="30000">৩০,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-success w-100 amount-btn" data-amount="50000">৫০,০০০ টাকা</button>
                                </div>
                            </div>
                        </div>

                        <form id="withdrawalForm">
                            <div class="mb-3">
                                <label class="form-label">উত্তোলনের পরিমান (টাকা)</label>
                                <input type="number" class="form-control" id="withdrawalAmount" name="amount" min="<?php echo $min_withdrawal; ?>" required>
                                <small class="text-muted">সর্বনিম্ন উত্তোলন: <?php echo $min_withdrawal; ?> টাকা</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">পেমেন্ট মেথড</label>
                                <select class="form-control" name="payment_method" id="paymentMethod" required>
                                    <option value="">মেথড নির্বাচন করুন</option>
                                    <?php while ($method = $payment_methods->fetch_assoc()): ?>
                                        <option value="<?php echo $method['id']; ?>"><?php echo $method['name']; ?> (<?php echo $method['number']; ?>)</option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">রিসিভার অ্যাকাউন্ট নাম্বার</label>
                                <input type="text" class="form-control" name="receiver_account" required>
                                <small class="text-muted">যে অ্যাকাউন্টে টাকা পাঠাতে চান</small>
                            </div>

                            <div class="alert alert-info">
                                <strong>নোট:</strong> উত্তোলন ফি: <?php echo $withdrawal_fee; ?> টাকা
                            </div>

                            <button type="submit" class="btn btn-success w-100" id="withdrawalBtn">
                                <i class="fas fa-paper-plane"></i> উত্তোলন রিকুয়েস্ট সাবমিট করুন
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Withdrawal History -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5><i class="fas fa-history"></i> উত্তোলন হিস্টরি</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>নং</th>
                                        <th>তারিখ</th>
                                        <th>টাইপ</th>
                                        <th>পরিমান</th>
                                        <th>ডিসপতিশন</th>
                                        <th>স্ট্যাটাস</th>
                                    </tr>
                                </thead>
                                <tbody id="withdrawalHistory">
                                    <!-- Withdrawal history will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/withdrawal.js"></script>
</body>
</html>
