<?php
require_once 'includes/config.php';
require_login();

$user = get_logged_in_user();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ট্রানজেকশন - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="container mt-4">
        <!-- Balance Section -->
        <div class="dashboard-card text-center mb-4">
            <h4>বর্তমান ব্যালেন্স</h4>
            <div class="balance-amount"><?php echo format_currency($user['balance']); ?></div>
        </div>

        <!-- Transaction History -->
        <div class="card">
            <div class="card-header">
                <h4><i class="fas fa-exchange-alt"></i> লেনদেন সমূহ</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>নং</th>
                                <th>তারিখ</th>
                                <th>ডিস্ক্রিপশন</th>
                                <th>নোট</th>
                                <th>ডেবিট</th>
                                <th>ক্রেডিট</th>
                                <th>ব্যালেন্স</th>
                            </tr>
                        </thead>
                        <tbody id="transactionHistory">
                            <!-- Transaction history will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/transaction.js"></script>
</body>
</html>
