<?php
require_once 'includes/config.php';
require_login();

$user = get_logged_in_user();

// Get referral stats
$stmt = $conn->prepare("SELECT COUNT(*) as total_referred FROM users WHERE referrer_id = ?");
$stmt->bind_param("i", $user['id']);
$stmt->execute();
$total_referred = $stmt->get_result()->fetch_assoc()['total_referred'];

$stmt = $conn->prepare("SELECT SUM(commission) as total_commission FROM referral_history WHERE user_id = ?");
$stmt->bind_param("i", $user['id']);
$stmt->execute();
$total_commission = $stmt->get_result()->fetch_assoc()['total_commission'] ?: 0;

// Get referral settings
$referral_settings = [];
$stmt = $conn->prepare("SELECT * FROM referral_settings ORDER BY level");
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $referral_settings[] = $row;
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>রেফারেল - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="container mt-4">
        <!-- Referral Stats -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-primary"><?php echo format_currency($total_commission); ?></h3>
                        <p>রেফারেল ব্যালেন্স</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-success"><?php echo $total_referred; ?></h3>
                        <p>মোট রেফার</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h3 class="text-info"><?php echo $user['referral_code']; ?></h3>
                        <p>রেফারেল কোড</p>
                        <button class="btn btn-sm btn-outline-primary" onclick="copyReferralCode()">কপি করুন</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Referral Link -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>রেফারেল লিংক</h5>
            </div>
            <div class="card-body">
                <div class="input-group">
                    <input type="text" class="form-control" id="referralLink" value="<?php echo "http://" . $_SERVER['HTTP_HOST'] . "/index.php?ref=" . $user['referral_code']; ?>" readonly>
                    <button class="btn btn-outline-primary" onclick="copyReferralLink()">কপি করুন</button>
                </div>
            </div>
        </div>

        <!-- Referral Bonus Structure -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>রেফার বোনাস স্ট্রাকচার</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php foreach ($referral_settings as $setting): ?>
                    <div class="col-md-4 mb-3">
                        <div class="card h-100 text-center">
                            <div class="card-body">
                                <h4 class="text-primary">লেভেল <?php echo $setting['level']; ?></h4>
                                <p class="mb-0"><?php echo $setting['commission_percentage']; ?>% কমিশন</p>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>

        <!-- Referral History -->
        <div class="card">
            <div class="card-header">
                <h5>রেফার হিস্টরি</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>নং</th>
                                <th>ইউজার</th>
                                <th>তারিখ</th>
                                <th>কমিশন</th>
                                <th>বোনাস</th>
                            </tr>
                        </thead>
                        <tbody id="referralHistory">
                            <!-- Referral history will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/referral.js"></script>
</body>
</html>
