<?php include 'includes/config.php'; ?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $company_name; ?> - Premium Investment</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Hind+Siliguri:wght@300;400;500;600;700&family=Outfit:wght@300;400;600&display=swap" rel="stylesheet">

    <style>
        :root {
            --bg-deep: #050a14;
            --bg-card: #0f172a;
            --accent-blue: #3b82f6;
            --accent-glow: rgba(59, 130, 246, 0.5);
            --text-gold: #fbbf24;
            --border-line: rgba(255, 255, 255, 0.08);
        }

        body {
            background-color: var(--bg-deep);
            color: #e2e8f0;
            font-family: 'Hind Siliguri', 'Outfit', sans-serif;
            letter-spacing: 0.5px;
        }

        /* Animated Background Blobs */
        .bg-blob {
            position: fixed;
            width: 300px;
            height: 300px;
            background: var(--accent-blue);
            filter: blur(150px);
            border-radius: 50%;
            z-index: -1;
            opacity: 0.15;
            animation: move 20s infinite alternate;
        }

        @keyframes move {
            from { transform: translate(-50%, -50%); }
            to { transform: translate(100%, 100%); }
        }

        /* Navbar Styling */
        .navbar {
            background: rgba(15, 23, 42, 0.8) !important;
            backdrop-filter: blur(20px);
            border-bottom: 1px solid var(--border-line);
        }

        /* Investment Sheet (As per screenshot mockup) */
        .premium-card {
            background: var(--bg-card);
            border: 1px solid var(--border-line);
            border-radius: 24px;
            overflow: hidden;
            box-shadow: 0 20px 50px rgba(0,0,0,0.3);
        }

        .sheet-header {
            background: linear-gradient(90deg, #1e293b, #0f172a);
            padding: 25px;
            border-bottom: 2px solid var(--accent-blue);
        }

        .sheet-title {
            color: #fff;
            font-weight: 700;
            display: flex;
            align-items: center;
            gap: 15px;
            font-size: 1.4rem;
        }

        .company-list-wrapper {
            padding: 10px;
        }

        /* Stylish List Rows */
        .company-row {
            display: grid;
            grid-template-columns: 1.2fr 0.8fr 1fr;
            align-items: center;
            padding: 18px 15px;
            margin-bottom: 10px;
            background: rgba(255,255,255,0.03);
            border-radius: 16px;
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .company-row:hover {
            background: rgba(59, 130, 246, 0.1);
            transform: scale(1.02);
            border-left: 4px solid var(--accent-blue);
        }

        .comp-name { font-weight: 600; font-size: 1.1rem; }
        .comp-return { color: var(--accent-blue); font-weight: 700; font-size: 1.1rem; }

        .btn-invest {
            background: linear-gradient(135deg, #3b82f6 0%, #1d4ed8 100%);
            border: none;
            padding: 10px 18px;
            border-radius: 12px;
            color: white;
            font-weight: 600;
            box-shadow: 0 4px 15px var(--accent-glow);
            font-size: 0.9rem;
            text-decoration: none;
            text-align: center;
            transition: 0.3s;
        }

        .btn-invest:hover {
            box-shadow: 0 8px 25px var(--accent-glow);
            transform: translateY(-2px);
            color: white;
        }

        /* Status Ticker */
        .ticker-wrap {
            background: #0f172a;
            border-bottom: 1px solid var(--border-line);
            padding: 8px 0;
            font-size: 0.9rem;
            color: var(--text-gold);
        }

        /* Hero Text Area */
        .hero-title {
            font-size: 3.5rem;
            font-weight: 800;
            background: linear-gradient(to right, #fff, #94a3b8);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            margin-bottom: 20px;
        }

        .trust-badge {
            background: rgba(59, 130, 246, 0.15);
            padding: 8px 20px;
            border-radius: 50px;
            border: 1px solid var(--accent-blue);
            color: var(--accent-blue);
            display: inline-block;
            margin-bottom: 20px;
        }

        /* Responsive */
        @media (max-width: 768px) {
            .hero-title { font-size: 2.2rem; }
            .company-row { font-size: 0.85rem; padding: 12px 10px; }
            .btn-invest { padding: 8px 10px; font-size: 0.8rem; }
        }
    </style>
</head>
<body>

    <div class="bg-blob"></div>

    <!-- Ticker -->
    <div class="ticker-wrap">
        <div class="container">
            <marquee><i class="fas fa-bolt"></i> আজই বিনিয়োগ করে আপনার নিরাপদ ভবিষ্যৎ নিশ্চিত করুন | মার্কেট এখন রানিং...</marquee>
        </div>
    </div>

    <!-- Nav -->
    <nav class="navbar navbar-expand-lg navbar-dark sticky-top">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="#">
                <img src="assets/img/logo.png" height="35" class="me-2" alt=""> <!-- লগো বসাতে পারবেন -->
                <span class="fw-bold tracking-tighter">FIN-TRADEX</span>
            </a>
            <div class="ms-auto d-flex align-items-center">
                <a href="#" class="btn btn-outline-light btn-sm me-2 rounded-pill px-4" data-bs-toggle="modal" data-bs-target="#loginModal">লগইন</a>
                <a href="#" class="btn btn-primary btn-sm rounded-pill px-4" data-bs-toggle="modal" data-bs-target="#registerModal">রেজিস্টার</a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <div class="container py-5">
        <div class="row g-5 align-items-center">

            <!-- Hero Side -->
            <div class="col-lg-5 text-center text-lg-start">
                <span class="trust-badge animate__animated animate__fadeIn"><i class="fas fa-shield-check"></i> ১১০% নিরাপদ বিনিয়োগ</span>
                <h1 class="hero-title">সহজ পথে সঠিক <br> অর্থ উপার্জন করুন।</h1>
                <p class="text-secondary fs-5 mb-4">আমাদের অভিজ্ঞ অ্যানালিস্ট প্যানেল আপনার শেয়ার কেনাবেচাকে সহজ ও প্রফিটেবল করে তুলবে।</p>

                <div class="row g-3">
                    <div class="col-6">
                        <div class="p-3 bg-dark rounded-4 border border-secondary border-opacity-25">
                            <h4 class="fw-bold text-white mb-0">১০কে+</h4>
                            <small class="text-secondary">সন্তুষ্ট গ্রাহক</small>
                        </div>
                    </div>
                    <div class="col-6">
                        <div class="p-3 bg-dark rounded-4 border border-secondary border-opacity-25">
                            <h4 class="fw-bold text-white mb-0">৯৮%</h4>
                            <small class="text-secondary">সাফল্যের হার</small>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Table Side (Premium Sheet Design) -->
            <div class="col-lg-7">
                <div class="premium-card">
                    <div class="sheet-header">
                        <div class="sheet-title">
                            <i class="fas fa-list-check"></i>
                            কোম্পানি/বিনিয়োগ তালিকা
                        </div>
                    </div>

                    <div class="company-list-wrapper">
                        <!-- Head Label -->
                        <div class="px-3 py-2 text-secondary d-grid text-center" style="grid-template-columns: 1.2fr 0.8fr 1.3fr;">
                            <small>কোম্পানি নাম</small>
                            <small>রিটার্ন (%)</small>
                            <small>অ্যাকশন</small>
                        </div>

                        <!-- Single Company Item -->
                        <div class="company-row">
                            <div class="comp-name">আকিজ গ্রুপ</div>
                            <div class="comp-return">৫.৮৭%</div>
                            <div class="text-end">
                                <a href="javascript:void(0)" onclick="openPrompt()" class="btn-invest">শেয়ার ক্রয় করুন</a>
                            </div>
                        </div>

                        <div class="company-row">
                            <div class="comp-name">আবুল খায়ের গ্রুপ</div>
                            <div class="comp-return">৮.৯৭%</div>
                            <div class="text-end">
                                <a href="javascript:void(0)" onclick="openPrompt()" class="btn-invest">শেয়ার ক্রয় করুন</a>
                            </div>
                        </div>

                        <div class="company-row">
                            <div class="comp-name">প্রাণ-আরএফএল</div>
                            <div class="comp-return">৬.৫০%</div>
                            <div class="text-end">
                                <a href="javascript:void(0)" onclick="openPrompt()" class="btn-invest">শেয়ার ক্রয় করুন</a>
                            </div>
                        </div>

                        <div class="company-row">
                            <div class="comp-name">মেঘনা গ্রুপ</div>
                            <div class="comp-return">৭.১২%</div>
                            <div class="text-end">
                                <a href="javascript:void(0)" onclick="openPrompt()" class="btn-invest">শেয়ার ক্রয় করুন</a>
                            </div>
                        </div>
                        <!-- PHP loop এর মাধ্যমে বাকি ডাটাগুলো আনবেন -->
                    </div>

                    <div class="p-3 text-center border-top border-secondary border-opacity-10">
                        <small class="text-secondary"><i class="fas fa-clock-rotate-left"></i> লাস্ট আপডেট ২ মিনিট আগে</small>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Stats Feature Section -->
    <section class="container pb-5 mt-5">
        <div class="row g-4 text-center">
            <div class="col-md-4">
                <div class="p-4 bg-card rounded-4 border border-line">
                    <i class="fas fa-bolt-lightning fa-2x text-warning mb-3"></i>
                    <h5>ইন্সট্যান্ট ডিপোজিট</h5>
                    <p class="small text-secondary mb-0">বিকাশ/নগদ এর মাধ্যমে ২ মিনিটেই মূলধন জমা করুন।</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="p-4 bg-card rounded-4 border border-line">
                    <i class="fas fa-hand-holding-dollar fa-2x text-success mb-3"></i>
                    <h5>প্রতিদিন উত্তোলন</h5>
                    <p class="small text-secondary mb-0">লাভ হওয়া মাত্রই টাকা তোলার আবেদন করুন প্রতিদিন।</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="p-4 bg-card rounded-4 border border-line">
                    <i class="fas fa-shield-virus fa-2x text-info mb-3"></i>
                    <h5>সুরক্ষিত লেনদেন</h5>
                    <p class="small text-secondary mb-0">প্রতিটি শেয়ার ক্রয় এবং প্রফিট স্বচ্ছ ও লিগ্যাল ভাবে প্রসেস করা হয়।</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Custom Popup for non-logged in users -->
    <div class="modal fade" id="authPrompt" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content" style="background: #111827; border: 1px solid var(--accent-blue); border-radius: 20px;">
                <div class="modal-body text-center p-5">
                    <div class="mb-4">
                        <i class="fas fa-user-lock fa-4x" style="color: var(--accent-blue);"></i>
                    </div>
                    <h3 class="fw-bold mb-3">লগইন প্রয়োজন!</h3>
                    <p class="text-secondary">শেয়ার ক্রয় বা প্রফিট দেখতে হলে আপনাকে আপনার অ্যাকাউন্টে লগইন করতে হবে।</p>
                    <div class="d-flex flex-column gap-3 mt-4">
                        <button class="btn btn-primary rounded-pill py-2" data-bs-dismiss="modal" data-bs-toggle="modal" data-bs-target="#loginModal">লগইন করুন</button>
                        <button class="btn btn-outline-secondary rounded-pill py-2" data-bs-dismiss="modal">বাতিল করুন</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Login Modal -->
    <div class="modal fade" id="loginModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" style="background: #111827; border: 1px solid var(--accent-blue);">
                <div class="modal-header" style="background: var(--accent-blue);">
                    <h5 class="modal-title text-white">লগইন</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="loginForm">
                        <div class="mb-3">
                            <label class="form-label text-white">ইমেইল</label>
                            <input type="email" class="form-control bg-dark text-white border-secondary" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-white">পাসওয়ার্ড</label>
                            <input type="password" class="form-control bg-dark text-white border-secondary" name="password" required>
                        </div>
                        <button type="submit" class="btn btn-primary w-100">লগইন</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Register Modal -->
    <div class="modal fade" id="registerModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content" style="background: #111827; border: 1px solid var(--accent-blue);">
                <div class="modal-header" style="background: var(--accent-blue);">
                    <h5 class="modal-title text-white">রেজিস্টার</h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form id="registerForm">
                        <div class="mb-3">
                            <label class="form-label text-white">পুরো নাম</label>
                            <input type="text" class="form-control bg-dark text-white border-secondary" name="full_name" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-white">ইমেইল</label>
                            <input type="email" class="form-control bg-dark text-white border-secondary" name="email" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-white">ফোন নম্বর</label>
                            <input type="tel" class="form-control bg-dark text-white border-secondary" name="phone" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-white">পাসওয়ার্ড</label>
                            <input type="password" class="form-control bg-dark text-white border-secondary" name="password" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-white">পাসওয়ার্ড নিশ্চিত করুন</label>
                            <input type="password" class="form-control bg-dark text-white border-secondary" name="confirm_password" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label text-white">রেফারেল কোড (ঐচ্ছিক)</label>
                            <input type="text" class="form-control bg-dark text-white border-secondary" name="referral_code">
                        </div>
                        <button type="submit" class="btn btn-success w-100">রেজিস্টার</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/script.js"></script>
    <script>
        function openPrompt() {
            var myModal = new bootstrap.Modal(document.getElementById('authPrompt'));
            myModal.show();
        }

        // Check for referral parameter and auto-open register modal
        document.addEventListener('DOMContentLoaded', function() {
            const urlParams = new URLSearchParams(window.location.search);
            const refCode = urlParams.get('ref');

            if (refCode) {
                // Pre-fill referral code field
                const referralInput = document.querySelector('#registerModal input[name="referral_code"]');
                if (referralInput) {
                    referralInput.value = refCode;
                }

                // Auto-open register modal
                const registerModal = new bootstrap.Modal(document.getElementById('registerModal'));
                registerModal.show();
            }
        });
    </script>
</body>
</html>
