<?php
// Database Configuration
define('DB_HOST', 'localhost');
define('DB_USER', 'dpxcom_jobkori'); // এখানে তুমি তোমার ডাটাবেজ ইউজারনাম দিবে
define('DB_PASS', 'dpxcom_jobkori'); // এখানে তুমি তোমার ডাটাবেজ password দিবে
define('DB_NAME', 'dpxcom_jobkori'); // এখানে তুমি তোমার ডাটাবেজ নাম দিবে

// Create database connection
$conn = new mysqli(DB_HOST, DB_USER, DB_PASS, DB_NAME);

// Check connection
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Set charset to utf8mb4 for Bangla support
$conn->set_charset("utf8mb4");

// Additional UTF-8 settings for proper Bangla support
$conn->query("SET NAMES utf8mb4");
$conn->query("SET CHARACTER SET utf8mb4");
$conn->query("SET collation_connection = utf8mb4_unicode_ci");

// Cron job security key
define('CRON_KEY', 'wtfbangla'); // এখানে তোমার ক্রন জব সিক্রেট কি দিবে

// Start session
session_start();

// Include functions
require_once 'functions.php';

// Get settings
function get_setting($key) {
    global $conn;
    $stmt = $conn->prepare("SELECT value FROM settings WHERE key_name = ?");
    $stmt->bind_param("s", $key);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        return $result->fetch_assoc()['value'];
    }
    return null;
}

// Check if user is logged in
function is_logged_in() {
    return isset($_SESSION['user_id']);
}

// Get current user info
function get_logged_in_user() {
    if (!is_logged_in()) return null;

    global $conn;
    $stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->bind_param("i", $_SESSION['user_id']);
    $stmt->execute();
    $result = $stmt->get_result();
    return $result->fetch_assoc();
}

// Redirect if not logged in
function require_login() {
    if (!is_logged_in()) {
        header("Location: index.php");
        exit();
    }
}

// Format currency in Bangladeshi Taka
function format_currency($amount) {
    return number_format($amount, 2) . ' টাকা';
}

// Generate random referral code
function generate_referral_code() {
    return strtoupper(substr(md5(uniqid()), 0, 8));
}

// Get company name from settings
$company_name = get_setting('DPX24') ?: 'শেয়ার বাজারে বিনিয়োগের একমাত্র আস্থার নাম'; // এখানে তোমার কোম্পানির নাম দিবে
?>
