<?php
require_once 'includes/config.php';
require_login();

$user = get_logged_in_user();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>হিস্টরি - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="container mt-4">
        <!-- Balance Section -->
        <div class="dashboard-card text-center mb-4">
            <h4>ব্যালেন্স</h4>
            <div class="balance-amount"><?php echo format_currency($user['balance']); ?></div>
        </div>

        <!-- Active Investments -->
        <div class="card mb-4">
            <div class="card-header">
                <h4><i class="fas fa-chart-line"></i> অ্যাক্টিভ বিনিয়োগ সমূহ</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>নং</th>
                                <th>কোম্পানির নাম</th>
                                <th>বিনিয়োগ</th>
                                <th>মূলধন</th>
                                <th>প্রফিট</th>
                                <th>মুনাফা পেতে বাকি আছে</th>
                                <th>বিনিয়োগ স্ট্যাটাস</th>
                            </tr>
                        </thead>
                        <tbody id="activeInvestments">
                            <!-- Active investments will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Investment History -->
        <div class="card mb-4">
            <div class="card-header">
                <h4><i class="fas fa-history"></i> বিনিয়োগ হিস্টরি</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>নং</th>
                                <th>কোম্পানির নাম</th>
                                <th>বিনিয়োগের পরিমান</th>
                                <th>প্রফিটের পরিমান</th>
                                <th>মোট প্রফিট</th>
                                <th>শুরুর তারিখ</th>
                                <th>স্ট্যাটাস</th>
                            </tr>
                        </thead>
                        <tbody id="investmentHistory">
                            <!-- Investment history will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/history.js"></script>
</body>
</html>
