<?php include 'includes/config.php'; ?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>হেল্প & সাপোর্ট - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="container mt-4">
        <h2 class="text-center mb-4">হেল্প এবং সাপোর্ট</h2>

        <div class="row">
            <div class="col-md-3 mb-3">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <i class="fas fa-user-plus fa-3x text-primary mb-3"></i>
                        <h5>কিভাবে অ্যাকাউন্ট খুলতে হবে?</h5>
                        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#videoModal" data-category="account_open">
                            ভিডিও দেখুন
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <i class="fas fa-money-bill-wave fa-3x text-success mb-3"></i>
                        <h5>কিভাবে মূলধন জমা করবেন?</h5>
                        <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#videoModal" data-category="deposit">
                            ভিডিও দেখুন
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <i class="fas fa-chart-line fa-3x text-info mb-3"></i>
                        <h5>কিভাবে বিনিয়োগ করবেন?</h5>
                        <button class="btn btn-info" data-bs-toggle="modal" data-bs-target="#videoModal" data-category="investment">
                            ভিডিও দেখুন
                        </button>
                    </div>
                </div>
            </div>
            <div class="col-md-3 mb-3">
                <div class="card h-100 text-center">
                    <div class="card-body">
                        <i class="fas fa-hand-holding-usd fa-3x text-warning mb-3"></i>
                        <h5>কিভাবে উত্তোলন করবেন?</h5>
                        <button class="btn btn-warning" data-bs-toggle="modal" data-bs-target="#videoModal" data-category="withdrawal">
                            ভিডিও দেখুন
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <div class="row mt-4">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>যোগাযোগ করুন</h5>
                    </div>
                    <div class="card-body">
                        <p><i class="fas fa-envelope"></i> support@investment.com</p>
                        <p><i class="fas fa-phone"></i> +880 1234-567890</p>
                        <p><i class="fas fa-clock"></i> ২৪/৭ সাপোর্ট</p>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">
                        <h5>সচরাচর জিজ্ঞাসা</h5>
                    </div>
                    <div class="card-body">
                        <div class="accordion" id="faqAccordion">
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#faq1">
                                        সর্বনিম্ন বিনিয়োগ কত?
                                    </button>
                                </h2>
                                <div id="faq1" class="accordion-collapse collapse show" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        সর্বনিম্ন বিনিয়োগ ৫০০ টাকা।
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item">
                                <h2 class="accordion-header">
                                    <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#faq2">
                                        কখন প্রফিট পাব?
                                    </button>
                                </h2>
                                <div id="faq2" class="accordion-collapse collapse" data-bs-parent="#faqAccordion">
                                    <div class="accordion-body">
                                        প্রতি দিন প্রফিট যুক্ত হয়ে যাবে এবং ৩০ দিন পর মূলধন ফেরত পাবেন।
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Video Modal -->
    <div class="modal fade" id="videoModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="videoTitle"></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="embed-responsive embed-responsive-16by9">
                        <iframe id="videoFrame" class="embed-responsive-item w-100" height="400" allowfullscreen></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/help.js"></script>
</body>
</html>
