<?php
require_once 'includes/config.php';
require_login();

$user = get_logged_in_user();

// Get settings
$min_deposit = get_setting('min_deposit') ?: 500;
$max_deposit = get_setting('max_deposit') ?: 50000;

// Get payment methods
$payment_methods = get_payment_methods('deposit');
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ডিপোজিট - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h4><i class="fas fa-money-bill-wave"></i> মূলধন জমা</h4>
                    </div>
                    <div class="card-body">
                        <!-- Quick Amount Selection -->
                        <div class="mb-4">
                            <h5>দ্রুত পরিমান নির্বাচন:</h5>
                            <div class="row">
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="1000">১,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="3000">৩,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="5000">৫,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="10000">১০,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="20000">২০,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="25000">২৫,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="30000">৩০,০০০ টাকা</button>
                                </div>
                                <div class="col-4 mb-2">
                                    <button class="btn btn-outline-primary w-100 amount-btn" data-amount="50000">৫০,০০০ টাকা</button>
                                </div>
                            </div>
                        </div>

                        <form id="depositForm">
                            <div class="mb-3">
                                <label class="form-label">জমার পরিমান (টাকা)</label>
                                <input type="number" class="form-control" id="depositAmount" name="amount" min="<?php echo $min_deposit; ?>" max="<?php echo $max_deposit; ?>" required>
                                <small class="text-muted">সর্বনিম্ন: <?php echo $min_deposit; ?> টাকা, সর্বোচ্চ: <?php echo $max_deposit; ?> টাকা</small>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">পেমেন্ট মেথড</label>
                                <select class="form-control" name="payment_method" id="paymentMethod" required>
                                    <option value="">মেথড নির্বাচন করুন</option>
                                    <?php
                                    $payment_methods->data_seek(0); // Reset pointer
                                    while ($method = $payment_methods->fetch_assoc()):
                                    ?>
                                        <option value="<?php echo $method['id']; ?>"
                                                data-number="<?php echo htmlspecialchars($method['number']); ?>"
                                                data-instructions="<?php echo htmlspecialchars($method['instructions']); ?>">
                                            <?php echo $method['name']; ?>
                                        </option>
                                    <?php endwhile; ?>
                                </select>
                            </div>

                            <!-- Payment Method Details (shown when method is selected) -->
                            <div id="methodDetails" class="mb-3" style="display: none;">
                                <div class="card border-primary">
                                    <div class="card-body">
                                        <h6 class="card-title text-primary">
                                            <i class="fas fa-info-circle"></i> পেমেন্ট তথ্য
                                        </h6>
                                        <div class="row">
                                            <div class="col-md-6">
                                                <label class="form-label">অ্যাকাউন্ট নাম্বার:</label>
                                                <div class="input-group">
                                                    <input type="text" class="form-control" id="methodNumber" readonly>
                                                    <button class="btn btn-outline-secondary" type="button" id="copyNumberBtn" title="কপি করুন">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <label class="form-label">পেমেন্ট ইন্সট্রাকশন:</label>
                                                <div id="methodInstructions" class="text-muted small"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">ট্রানজেকশন আইডি (Trx ID)</label>
                                <input type="text" class="form-control" name="trx_id" required>
                                <small class="text-muted">পেমেন্ট করার পর প্রাপ্ত ট্রানজেকশন আইডি দিন</small>
                            </div>

                            <button type="submit" class="btn btn-success w-100" id="depositBtn">
                                <i class="fas fa-paper-plane"></i> জমা রিকুয়েস্ট সাবমিট করুন
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Instructions -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5><i class="fas fa-info-circle"></i> নির্দেশনা</h5>
                    </div>
                    <div class="card-body">
                        <ol class="mb-0">
                            <li>প্রথমে আপনার বিনিয়োগের পরিমান সিলেক্ট করুন</li>
                            <li>এরপর পেমেন্ট মেথড সিলেক্ট করুন</li>
                            <li>এরপর আপনি send money করুন</li>
                            <li>এরপর পেমেন্ট করে আপনার trx ID submit করুন</li>
                            <li>১০ মিনিট পর মধ্যে automatic আপনার মূলধন যুক্ত হয়ে যাবে আপনার অ্যাকাউন্ট এ</li>
                        </ol>
                    </div>
                </div>

                <!-- Deposit History -->
                <div class="card mt-4">
                    <div class="card-header">
                        <h5><i class="fas fa-history"></i> জমার হিস্টরি</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-striped">
                                <thead>
                                    <tr>
                                        <th>নং</th>
                                        <th>তারিখ</th>
                                        <th>টাইপ</th>
                                        <th>পরিমান</th>
                                        <th>স্ট্যাটাস</th>
                                    </tr>
                                </thead>
                                <tbody id="depositHistory">
                                    <!-- Deposit history will be loaded here -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
    <script src="assets/js/deposit.js"></script>
    <script>
        // Payment method selection handler
        document.getElementById('paymentMethod').addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const methodNumber = selectedOption.getAttribute('data-number');
            const methodInstructions = selectedOption.getAttribute('data-instructions');

            if (methodNumber) {
                // Show method details
                document.getElementById('methodDetails').style.display = 'block';
                document.getElementById('methodNumber').value = methodNumber;

                // Show instructions
                if (methodInstructions) {
                    document.getElementById('methodInstructions').innerHTML = methodInstructions.replace(/\n/g, '<br>');
                } else {
                    document.getElementById('methodInstructions').innerHTML = '<em class="text-muted">কোন বিশেষ নির্দেশনা নেই</em>';
                }
            } else {
                // Hide method details if no method selected
                document.getElementById('methodDetails').style.display = 'none';
            }
        });

        // Copy to clipboard functionality
        document.getElementById('copyNumberBtn').addEventListener('click', function() {
            const numberInput = document.getElementById('methodNumber');
            const number = numberInput.value;

            if (number) {
                // Use modern clipboard API if available
                if (navigator.clipboard && window.isSecureContext) {
                    navigator.clipboard.writeText(number).then(function() {
                        showCopySuccess();
                    }).catch(function(err) {
                        console.error('Failed to copy: ', err);
                        fallbackCopyTextToClipboard(number);
                    });
                } else {
                    // Fallback for older browsers
                    fallbackCopyTextToClipboard(number);
                }
            }
        });

        function fallbackCopyTextToClipboard(text) {
            const textArea = document.createElement("textarea");
            textArea.value = text;
            textArea.style.position = "fixed";
            textArea.style.left = "-999999px";
            textArea.style.top = "-999999px";
            document.body.appendChild(textArea);
            textArea.focus();
            textArea.select();

            try {
                const successful = document.execCommand('copy');
                if (successful) {
                    showCopySuccess();
                } else {
                    showCopyError();
                }
            } catch (err) {
                console.error('Fallback: Oops, unable to copy', err);
                showCopyError();
            }

            document.body.removeChild(textArea);
        }

        function showCopySuccess() {
            const btn = document.getElementById('copyNumberBtn');
            const originalIcon = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-check text-success"></i>';
            btn.classList.add('btn-success');
            btn.classList.remove('btn-outline-secondary');

            setTimeout(function() {
                btn.innerHTML = originalIcon;
                btn.classList.remove('btn-success');
                btn.classList.add('btn-outline-secondary');
            }, 2000);
        }

        function showCopyError() {
            const btn = document.getElementById('copyNumberBtn');
            const originalIcon = btn.innerHTML;
            btn.innerHTML = '<i class="fas fa-times text-danger"></i>';

            setTimeout(function() {
                btn.innerHTML = originalIcon;
            }, 2000);
        }

        // Amount selection buttons
        document.querySelectorAll('.amount-btn').forEach(button => {
            button.addEventListener('click', function() {
                const amount = this.getAttribute('data-amount');
                document.getElementById('depositAmount').value = amount;

                // Remove active class from all buttons
                document.querySelectorAll('.amount-btn').forEach(btn => {
                    btn.classList.remove('active');
                    btn.classList.remove('btn-primary');
                    btn.classList.add('btn-outline-primary');
                });

                // Add active class to clicked button
                this.classList.add('active');
                this.classList.remove('btn-outline-primary');
                this.classList.add('btn-primary');
            });
        });
    </script>
</body>
</html>
