<?php
require_once 'includes/config.php';
require_login();

$user = get_logged_in_user();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>ড্যাশবোর্ড - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <!-- Dashboard Content -->
    <div class="container mt-4">
        <!-- Balance Section -->
        <div class="dashboard-card text-center mb-4">
            <h2>ব্যালেন্স</h2>
            <div class="balance-amount"><?php echo format_currency($user['balance']); ?></div>
            <div class="row mt-4">
                <div class="col-4 mb-3">
                    <a href="deposit.php" class="btn btn-share">
                        মূলধন
                    </a>
                </div>
                <div class="col-4 mb-3">
                    <a href="withdrawal.php" class="btn btn-share">
                        উত্তোলন
                    </a>
                </div>
                <div class="col-4 mb-3">
                    <a href="history.php" class="btn btn-share">
                        হিস্টরি
                    </a>
                </div>
            </div>
        </div>

        <!-- Notice Section -->
        <div class="notice-section mb-4" id="noticeSection" style="display: none;">
            <div class="alert alert-info notice-alert slide-in-notice">
                <div class="notice-content">
                    <h6 id="noticeTitle"><i class="fas fa-bullhorn"></i> বিজ্ঞপ্তি</h6>
                    <p id="noticeMessage"></p>
                </div>
                <button type="button" class="btn-close btn-close-notice" onclick="hideNotice()"></button>
            </div>
        </div>

        <!-- Company Choose Section -->
        <div class="card mb-4">
            <div class="card-header">
                <h4>বিনিয়োগ ক্যাটাগরি নির্বাচন করুন</h4>
            </div>
            <div class="card-body">
                <div class="row justify-content-center">
                    <div class="col-6 mb-3">
                        <button class="btn btn-outline-primary btn-lg w-100 category-btn-dashboard" data-category="general">
                            <i class="fas fa-chart-line fa-2x"></i><br>সাধারণ বিনিয়োগ
                        </button>
                    </div>
                    <div class="col-6 mb-3">
                        <button class="btn btn-outline-success btn-lg w-100 category-btn-dashboard" data-category="master">
                            <i class="fas fa-crown fa-2x"></i><br>মাস্টার বিনিয়োগ
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Company List Section -->
        <div class="card mb-4" id="companyListDashboard" style="display: none;">
            <div class="card-header">
                <h4><i class="fas fa-chart-line"></i> কোম্পানি/বিনিয়োগ তালিকা</h4>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table company-table">
                        <thead>
                            <tr>
                                <th class="text-start">কোম্পানি</th>
                                <th class="text-center">রিটার্ন</th>
                                <th class="text-end">শেয়ার ক্রয় করুন</th>
                            </tr>
                        </thead>
                        <tbody id="companiesContainerDashboard">
                            <!-- Companies will be loaded here -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Warning Section -->
        <div class="alert alert-danger">
            <h5><i class="fas fa-exclamation-triangle"></i> সতর্কবাণী</h5>
            <p>প্রিয় গ্রাহক,<br>
            আমাদের জবকরি লিঃ যাত্রা শুরু করে ০৯ মে ২০২৫।কিন্তু সম্প্রতি আমাদের "জব করি "-এর মতো দেখতে কিছু ভুয়া সাইট চালু হয়েছে। দয়া করে এসব সাইটে বিনিয়োগ করা থেকে বিরত থাকুন, কারণ সেখানে আপনার অর্থ হারানোর ঝুঁকি রয়েছে।<br>
            <strong>বি: দ্র:</strong> এ ধরনের সাইট দেখলে সাথে সাথে আমাদের সাপোর্ট টিমকে জানান। আমরা তাদের বিরুদ্ধে আইনি ব্যবস্থা নেব।</p>
        </div>
    </div>

    <!-- Investment Modal -->
    <div class="modal fade" id="investmentModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content modal-investment">
                <div class="modal-header">
                    <h5 class="modal-title text-center"><i class="fas fa-dollar-sign"></i> বিনিয়োগের বিস্তারিত</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="investment-banner">
                        <i class="fas fa-building"></i> <span id="companyNameBanner"></span>
                    </div>
                    <div class="investment-details">
                        <div class="detail-row">
                            <div class="detail-item">
                                <i class="fas fa-laptop"></i> <strong>কোম্পানির নাম:</strong> <span id="companyNameDetail"></span>
                            </div>
                            <div class="detail-item">
                                <i class="fas fa-money-bill-wave"></i> <strong>প্রফিটের পার্সেন্ট:</strong> <span id="returnRateDetail" class="profit-rate"></span>
                            </div>
                        </div>
                    </div>
                    <form id="investmentForm">
                        <input type="hidden" name="company_id" id="companyId">
                        <div class="mb-3">
                            <label class="form-label">বিনিয়োগের পরিমাণ লিখুন:</label>
                            <input type="number" class="form-control" name="amount" id="investmentAmount" min="500" placeholder="৫০০" required>
                        </div>
                        <div class="mb-3 profit-calculation">
                            <i class="fas fa-hand-holding-usd"></i> <strong>মোট প্রফিট পাবেন:</strong> <span id="totalProfitDisplay">৳ 0 (প্রতি ১ দিন এ)</span>
                        </div>
                        <button type="submit" class="btn btn-invest-confirm w-100" id="investBtn"><i class="fas fa-check-circle"></i> বিনিয়োগ নিশ্চিত করুন</button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="mt-5">
        <div class="container text-center">
            <p>&copy; 2025 <?php echo $company_name; ?>. All rights reserved.</p>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dashboard.js"></script>
</body>
</html>
