<?php
/**
 * Daily Profit Processing Cron Job
 *
 * This script should be run daily (e.g., via cron job) to process daily profits
 * for active investments and complete matured investments.
 *
 * Example cron job (run daily at 2 AM):
 * 0 2 * * * /usr/bin/php /path/to/project/cron/process_profits.php
 */

require_once '../includes/config.php';

// Process daily profits
process_daily_profits();

echo "Daily profit processing completed at " . date('Y-m-d H:i:s') . "\n";

// Optional: Log completion
$log_file = __DIR__ . '/../logs/cron.log';
$log_message = "[" . date('Y-m-d H:i:s') . "] Daily profit processing completed\n";

if (!is_dir(dirname($log_file))) {
    mkdir(dirname($log_file), 0755, true);
}

file_put_contents($log_file, $log_message, FILE_APPEND);
?>
