// Referral JavaScript

document.addEventListener('DOMContentLoaded', function() {
    // Initialize referral page
    initReferral();
});

function initReferral() {
    // Load referral history
    loadReferralHistory();
}

function loadReferralHistory() {
    fetch('api/get_referral_history.php')
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                displayReferralHistory(data.history);
            }
        })
        .catch(error => {
            console.error('Error loading referral history:', error);
        });
}

function displayReferralHistory(history) {
    const container = document.getElementById('referralHistory');

    if (history.length === 0) {
        container.innerHTML = '<tr><td colspan="5" class="text-center">কোন রেফারেল হিস্টরি নেই</td></tr>';
        return;
    }

    let html = '';
    history.forEach((item, index) => {
        const date = new Date(item.created_at).toLocaleDateString('bn-BD');

        html += `
            <tr>
                <td>${index + 1}</td>
                <td>${item.referred_user_name}</td>
                <td>${date}</td>
                <td>${formatCurrency(item.commission)}</td>
                <td>লেভেল ${item.level}</td>
            </tr>
        `;
    });

    container.innerHTML = html;
}

function copyReferralCode() {
    const code = "<?php echo $user['referral_code']; ?>";
    navigator.clipboard.writeText(code).then(() => {
        showAlert('রেফারেল কোড কপি হয়েছে!', 'success');
    });
}

function copyReferralLink() {
    const link = document.getElementById('referralLink').value;
    navigator.clipboard.writeText(link).then(() => {
        showAlert('রেফারেল লিংক কপি হয়েছে!', 'success');
    });
}

function formatCurrency(amount) {
    return new Intl.NumberFormat('bn-BD', {
        style: 'currency',
        currency: 'BDT'
    }).format(amount);
}

function showAlert(message, type = 'info') {
    const alertContainer = document.createElement('div');
    alertContainer.className = `alert alert-${type} alert-dismissible fade show position-fixed`;
    alertContainer.style.cssText = 'top: 20px; right: 20px; z-index: 9999; min-width: 300px;';
    alertContainer.innerHTML = `
        ${message}
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    `;

    document.body.appendChild(alertContainer);

    setTimeout(() => {
        if (alertContainer.parentNode) {
            alertContainer.remove();
        }
    }, 3000);
}
