// Help JavaScript

document.addEventListener('DOMContentLoaded', function() {
    // Set up video modal
    const videoModal = document.getElementById('videoModal');
    if (videoModal) {
        videoModal.addEventListener('show.bs.modal', function(event) {
            const button = event.relatedTarget;
            const category = button.getAttribute('data-category');
            loadVideo(category);
        });
    }
});

function loadVideo(category) {
    fetch('api/get_video.php?category=' + category)
        .then(response => response.json())
        .then(data => {
            if (data.success && data.video) {
                document.getElementById('videoTitle').textContent = data.video.title;
                document.getElementById('videoFrame').src = data.video.url;
            } else {
                document.getElementById('videoTitle').textContent = 'ভিডিও পাওয়া যায়নি';
                document.getElementById('videoFrame').src = '';
            }
        })
        .catch(error => {
            console.error('Error:', error);
            document.getElementById('videoTitle').textContent = 'ভিডিও লোড করতে ব্যর্থ';
        });
}
