// Admin Users Management JavaScript

document.addEventListener('DOMContentLoaded', function() {
    // Initialize user management
    initUserManagement();
});

function initUserManagement() {
    // Set up search functionality
    const searchInput = document.getElementById('searchUser');
    if (searchInput) {
        searchInput.addEventListener('input', debounce(filterUsers, 300));
    }

    const statusFilter = document.getElementById('statusFilter');
    if (statusFilter) {
        statusFilter.addEventListener('change', filterUsers);
    }
}

function filterUsers() {
    const searchTerm = document.getElementById('searchUser').value.toLowerCase();
    const statusFilter = document.getElementById('statusFilter').value;
    const rows = document.querySelectorAll('#usersTable tr');

    rows.forEach(row => {
        const cells = row.querySelectorAll('td');
        if (cells.length < 3) return; // Skip header or invalid rows

        const name = cells[1].textContent.toLowerCase();
        const email = cells[2].textContent.toLowerCase();
        const phone = cells[3].textContent.toLowerCase();
        const statusBadge = cells[5].querySelector('.badge');

        let status = '';
        if (statusBadge) {
            status = statusBadge.textContent.trim() === 'অ্যাক্টিভ' ? 'active' : 'inactive';
        }

        const matchesSearch = name.includes(searchTerm) ||
                            email.includes(searchTerm) ||
                            phone.includes(searchTerm);

        const matchesStatus = !statusFilter || status === statusFilter;

        if (matchesSearch && matchesStatus) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}

// Utility function for debouncing
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}

// Export functions for global use
window.filterUsers = filterUsers;
