// Admin Transactions Management JavaScript

function approveTransaction(transactionId) {
    if (!confirm('আপনি কি এই ট্রানজেকশন অনুমোদন করতে চান?')) {
        return;
    }

    fetch(`api/approve_transaction.php?id=${transactionId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showMessage('ট্রানজেকশন অনুমোদিত হয়েছে!', 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showMessage(data.message || 'ট্রানজেকশন অনুমোদন ব্যর্থ', 'danger');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('নেটওয়ার্ক ত্রুটি', 'danger');
        });
}

function rejectTransaction(transactionId) {
    if (!confirm('আপনি কি এই ট্রানজেকশন প্রত্যাখ্যান করতে চান?')) {
        return;
    }

    fetch(`api/reject_transaction.php?id=${transactionId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showMessage('ট্রানজেকশন প্রত্যাখ্যাত হয়েছে!', 'warning');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showMessage(data.message || 'ট্রানজেকশন প্রত্যাখ্যান ব্যর্থ', 'danger');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('নেটওয়ার্ক ত্রুটি', 'danger');
        });
}

function showMessage(message, type = 'info') {
    const messageContainer = document.getElementById('messageContainer');
    const alertClass = type === 'success' ? 'alert-success' :
                      type === 'danger' ? 'alert-danger' :
                      type === 'warning' ? 'alert-warning' : 'alert-info';

    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;

    messageContainer.innerHTML = alertHtml;

    // Auto remove after 5 seconds
    setTimeout(() => {
        if (messageContainer.firstElementChild) {
            messageContainer.firstElementChild.remove();
        }
    }, 5000);
}

// Bulk actions (future enhancement)
function selectAllTransactions() {
    const checkboxes = document.querySelectorAll('.transaction-checkbox');
    const selectAllCheckbox = document.getElementById('selectAllTransactions');

    checkboxes.forEach(checkbox => {
        checkbox.checked = selectAllCheckbox.checked;
    });
}

function bulkApprove() {
    const selectedTransactions = document.querySelectorAll('.transaction-checkbox:checked');
    if (selectedTransactions.length === 0) {
        showMessage('কোন ট্রানজেকশন সিলেক্ট করা হয়নি', 'warning');
        return;
    }

    if (!confirm(`${selectedTransactions.length} টি ট্রানজেকশন অনুমোদন করতে চান?`)) {
        return;
    }

    // Implement bulk approval logic here
    showMessage('বাল্ক অ্যাপ্রুভাল ফিচার শীঘ্রই যোগ করা হবে', 'info');
}

function bulkReject() {
    const selectedTransactions = document.querySelectorAll('.transaction-checkbox:checked');
    if (selectedTransactions.length === 0) {
        showMessage('কোন ট্রানজেকশন সিলেক্ট করা হয়নি', 'warning');
        return;
    }

    if (!confirm(`${selectedTransactions.length} টি ট্রানজেকশন প্রত্যাখ্যান করতে চান?`)) {
        return;
    }

    // Implement bulk rejection logic here
    showMessage('বাল্ক রিজেকশন ফিচার শীঘ্রই যোগ করা হবে', 'info');
}
