// Admin Companies Management JavaScript

function editCompany(id, name, category, returnPercentage) {
    document.getElementById('editCompanyId').value = id;
    document.getElementById('editCompanyName').value = name;
    document.getElementById('editCompanyCategory').value = category;
    document.getElementById('editCompanyReturn').value = returnPercentage;

    const modal = new bootstrap.Modal(document.getElementById('editCompanyModal'));
    modal.show();
}

function deleteCompany(id, name) {
    document.getElementById('deleteCompanyId').value = id;
    document.getElementById('deleteCompanyName').textContent = name;

    const modal = new bootstrap.Modal(document.getElementById('deleteCompanyModal'));
    modal.show();
}

// Form validation
document.addEventListener('DOMContentLoaded', function() {
    // Add company form validation
    const addForm = document.getElementById('addCompanyForm');
    if (addForm) {
        addForm.addEventListener('submit', function(e) {
            const returnPercentage = parseFloat(this.return_percentage.value);
            if (returnPercentage <= 0 || returnPercentage > 100) {
                e.preventDefault();
                alert('রিটার্ন পার্সেন্টেজ 0.01 থেকে 100 এর মধ্যে হতে হবে');
                return false;
            }
        });
    }

    // Edit company form validation
    const editForm = document.getElementById('editCompanyForm');
    if (editForm) {
        editForm.addEventListener('submit', function(e) {
            const returnPercentage = parseFloat(this.return_percentage.value);
            if (returnPercentage <= 0 || returnPercentage > 100) {
                e.preventDefault();
                alert('রিটার্ন পার্সেন্টেজ 0.01 থেকে 100 এর মধ্যে হতে হবে');
                return false;
            }
        });
    }
});
