// Admin JavaScript

function approveTransaction(transactionId) {
    if (!confirm('আপনি কি এই ট্রানজেকশন অনুমোদন করতে চান?')) {
        return;
    }

    fetch(`api/approve_transaction.php?id=${transactionId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showMessage('ট্রানজেকশন অনুমোদিত হয়েছে!', 'success');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showMessage(data.message || 'ট্রানজেকশন অনুমোদন ব্যর্থ', 'danger');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('নেটওয়ার্ক ত্রুটি', 'danger');
        });
}

function rejectTransaction(transactionId) {
    if (!confirm('আপনি কি এই ট্রানজেকশন প্রত্যাখ্যান করতে চান?')) {
        return;
    }

    fetch(`api/reject_transaction.php?id=${transactionId}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                showMessage('ট্রানজেকশন প্রত্যাখ্যাত হয়েছে!', 'warning');
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                showMessage(data.message || 'ট্রানজেকশন প্রত্যাখ্যান ব্যর্থ', 'danger');
            }
        })
        .catch(error => {
            console.error('Error:', error);
            showMessage('নেটওয়ার্ক ত্রুটি', 'danger');
        });
}

function showMessage(message, type = 'info') {
    const messageContainer = document.getElementById('messageContainer');
    const alertClass = type === 'success' ? 'alert-success' :
                      type === 'danger' ? 'alert-danger' :
                      type === 'warning' ? 'alert-warning' : 'alert-info';

    const alertHtml = `
        <div class="alert ${alertClass} alert-dismissible fade show" role="alert">
            ${message}
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    `;

    messageContainer.innerHTML = alertHtml;

    // Auto remove after 5 seconds
    setTimeout(() => {
        if (messageContainer.firstElementChild) {
            messageContainer.firstElementChild.remove();
        }
    }, 5000);
}

// Navbar toggle functionality
document.addEventListener('DOMContentLoaded', function() {
    const navbar = document.querySelector('.navbar');
    const navbarToggler = document.querySelector('.navbar-toggler');
    const navbarBackdrop = document.querySelector('.navbar-backdrop');

    if (navbarToggler && navbar && navbarBackdrop) {
        // Toggle navbar on button click
        navbarToggler.addEventListener('click', function(e) {
            e.preventDefault();
            navbar.classList.toggle('show');
            navbarBackdrop.classList.toggle('show');
        });

        // Close navbar when clicking backdrop
        navbarBackdrop.addEventListener('click', function() {
            navbar.classList.remove('show');
            navbarBackdrop.classList.remove('show');
        });

        // Close navbar on escape key
        document.addEventListener('keydown', function(e) {
            if (e.key === 'Escape' && navbar.classList.contains('show')) {
                navbar.classList.remove('show');
                navbarBackdrop.classList.remove('show');
            }
        });
    }
});

// Additional admin functions can be added here
function formatCurrency(amount) {
    return new Intl.NumberFormat('bn-BD', {
        style: 'currency',
        currency: 'BDT'
    }).format(amount);
}
