<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'লগইন প্রয়োজন']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$user_id = $_SESSION['user_id'];
$amount = (float)($_POST['amount'] ?? 0);
$payment_method_id = (int)($_POST['payment_method'] ?? 0);
$receiver_account = trim($_POST['receiver_account'] ?? '');

if ($amount <= 0 || empty($receiver_account) || $payment_method_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'সকল ফিল্ড পূরণ করুন']);
    exit();
}

// Check limits
$min_withdrawal = get_setting('min_withdrawal') ?: 400;

if ($amount < $min_withdrawal) {
    echo json_encode(['success' => false, 'message' => "উইথড্রয়াল পরিমান কমপক্ষে {$min_withdrawal} টাকা হতে হবে"]);
    exit();
}

// Get payment method name
$stmt = $conn->prepare("SELECT name FROM payment_methods WHERE id = ? AND type = 'withdrawal'");
$stmt->bind_param("i", $payment_method_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo json_encode(['success' => false, 'message' => 'অবৈধ পেমেন্ট মেথড']);
    exit();
}

$payment_method = $result->fetch_assoc()['name'];

$result = submit_withdrawal($user_id, $amount, $payment_method, $receiver_account);

echo json_encode($result);
?>
