<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

// Check request method (GET for cron job services)
if ($_SERVER['REQUEST_METHOD'] !== 'GET') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

// Security check: verify cron key
$provided_key = $_GET['key'] ?? '';
if ($provided_key !== CRON_KEY) {
    echo json_encode(['success' => false, 'message' => 'Unauthorized access']);
    exit();
}

try {
    // Process daily profits
    process_daily_profits();

    echo json_encode([
        'success' => true,
        'message' => 'Daily profit processing completed successfully at ' . date('Y-m-d H:i:s')
    ]);
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'Error processing profits: ' . $e->getMessage()
    ]);
}
?>