<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'লগইন প্রয়োজন']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$company_id = (int)($_POST['company_id'] ?? 0);
$amount = (float)($_POST['amount'] ?? 0);
$user_id = $_SESSION['user_id'];

if ($company_id <= 0 || $amount <= 0) {
    echo json_encode(['success' => false, 'message' => 'অবৈধ ইনপুট']);
    exit();
}

// Check minimum investment
if ($amount < 500) {
    echo json_encode(['success' => false, 'message' => 'সর্বনিম্ন বিনিয়োগ ৫০০ টাকা']);
    exit();
}

// Check user balance
$user = get_logged_in_user();
if ($user['balance'] < $amount) {
    echo json_encode(['success' => false, 'message' => 'যথেষ্ট ব্যালেন্স নেই']);
    exit();
}

$result = create_investment($user_id, $company_id, $amount);

echo json_encode($result);
?>
