<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'লগইন প্রয়োজন']);
    exit();
}

$user_id = $_SESSION['user_id'];
$type = $_GET['type'] ?? 'all';

$query = "SELECT * FROM transactions WHERE user_id = ?";
$params = [$user_id];
$types = "i";

if ($type !== 'all') {
    $query .= " AND type = ?";
    $params[] = $type;
    $types .= "s";
}

$query .= " ORDER BY created_at DESC LIMIT 50";

$stmt = $conn->prepare($query);

if (count($params) > 1) {
    $stmt->bind_param($types, ...$params);
} else {
    $stmt->bind_param($types, $params[0]);
}

$stmt->execute();
$result = $stmt->get_result();

$transactions = [];
while ($row = $result->fetch_assoc()) {
    $transactions[] = $row;
}

echo json_encode(['success' => true, 'transactions' => $transactions]);
?>
