<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'লগইন প্রয়োজন']);
    exit();
}

$user_id = $_SESSION['user_id'];

$query = "SELECT rh.*, u.full_name as referred_user_name FROM referral_history rh JOIN users u ON rh.referred_user_id = u.id WHERE rh.user_id = ? ORDER BY rh.created_at DESC";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $user_id);
$stmt->execute();
$result = $stmt->get_result();

$history = [];
while ($row = $result->fetch_assoc()) {
    $history[] = $row;
}

echo json_encode(['success' => true, 'history' => $history]);
?>
