<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

try {
    $notices = get_active_notices();
    $notices_array = [];

    while ($notice = $notices->fetch_assoc()) {
        $notices_array[] = $notice;
    }

    echo json_encode([
        'success' => true,
        'notices' => $notices_array
    ]);

} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'message' => 'নোটিশ লোড করতে ব্যর্থ হয়েছে'
    ]);
}
?>
