<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'লগইন প্রয়োজন']);
    exit();
}

$user_id = $_SESSION['user_id'];
$status = $_GET['status'] ?? 'all';

$query = "SELECT i.*, c.name as company_name FROM investments i JOIN companies c ON i.company_id = c.id WHERE i.user_id = ?";
$params = [$user_id];
$types = "i";

if ($status !== 'all') {
    $query .= " AND i.status = ?";
    $params[] = $status;
    $types .= "s";
}

$query .= " ORDER BY i.created_at DESC";

$stmt = $conn->prepare($query);

if (count($params) > 1) {
    $stmt->bind_param($types, ...$params);
} else {
    $stmt->bind_param($types, $params[0]);
}

$stmt->execute();
$result = $stmt->get_result();

$investments = [];
while ($row = $result->fetch_assoc()) {
    $investments[] = $row;
}

echo json_encode(['success' => true, 'investments' => $investments]);
?>
