<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

$category = $_GET['category'] ?? '';

if (!in_array($category, ['general', 'master', ''])) {
    echo json_encode(['success' => false, 'message' => 'Invalid category']);
    exit();
}

if ($category === '') {
    // Get all companies
    global $conn;
    $stmt = $conn->prepare("SELECT * FROM companies ORDER BY name");
    $stmt->execute();
    $companies = $stmt->get_result();
} else {
    $companies = get_companies_by_category($category);
}
$companies_array = [];

while ($company = $companies->fetch_assoc()) {
    $companies_array[] = $company;
}

echo json_encode(['success' => true, 'companies' => $companies_array]);
?>
