<?php
require_once '../includes/config.php';

header('Content-Type: application/json');

if (!is_logged_in()) {
    echo json_encode(['success' => false, 'message' => 'লগইন প্রয়োজন']);
    exit();
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Invalid request method']);
    exit();
}

$user_id = $_SESSION['user_id'];
$amount = (float)($_POST['amount'] ?? 0);
$payment_method_id = (int)($_POST['payment_method'] ?? 0);
$trx_id = trim($_POST['trx_id'] ?? '');

if ($amount <= 0 || empty($trx_id) || $payment_method_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'সকল ফিল্ড পূরণ করুন']);
    exit();
}

// Check limits
$min_deposit = get_setting('min_deposit') ?: 500;
$max_deposit = get_setting('max_deposit') ?: 50000;

if ($amount < $min_deposit || $amount > $max_deposit) {
    echo json_encode(['success' => false, 'message' => "ডিপোজিট পরিমান {$min_deposit} থেকে {$max_deposit} টাকার মধ্যে হতে হবে"]);
    exit();
}

// Get payment method name
$stmt = $conn->prepare("SELECT name FROM payment_methods WHERE id = ? AND type = 'deposit'");
$stmt->bind_param("i", $payment_method_id);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows == 0) {
    echo json_encode(['success' => false, 'message' => 'অবৈধ পেমেন্ট মেথড']);
    exit();
}

$payment_method = $result->fetch_assoc()['name'];

$result = submit_deposit($user_id, $amount, $payment_method, $trx_id);

echo json_encode($result);
?>
