<?php
header('Content-Type: text/html; charset=UTF-8');
require_once '../includes/config.php';

// Simple admin check
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

// Create uploads directory if it doesn't exist
$upload_dir = '../uploads/certificates/';
if (!file_exists($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Handle form submissions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];

        if ($action === 'update_settings') {
            $withdrawal_fee = (float)$_POST['withdrawal_fee'];

            // Update withdrawal fee
            $stmt = $conn->prepare("INSERT INTO settings (key_name, value) VALUES ('withdrawal_fee', ?) ON DUPLICATE KEY UPDATE value = ?");
            $stmt->bind_param("ss", $withdrawal_fee, $withdrawal_fee);

            if ($stmt->execute()) {
                $message = 'সেটিংস সফলভাবে আপডেট করা হয়েছে';
                $message_type = 'success';
            } else {
                $message = 'সেটিংস আপডেট করতে ব্যর্থ। অনুগ্রহ করে আবার চেষ্টা করুন।';
                $message_type = 'danger';
            }
        } elseif ($action === 'update_referral_settings') {
            if (isset($_POST['commission'])) {
                $update_success = true;
                foreach ($_POST['commission'] as $level => $percentage) {
                    $stmt = $conn->prepare("UPDATE referral_settings SET commission_percentage = ? WHERE level = ?");
                    $stmt->bind_param("di", $percentage, $level);
                    if (!$stmt->execute()) {
                        $update_success = false;
                        break;
                    }
                }

                if ($update_success) {
                    $message = 'রেফারেল কমিশন সেটিংস সফলভাবে আপডেট করা হয়েছে';
                    $message_type = 'success';
                } else {
                    $message = 'রেফারেল সেটিংস আপডেট করতে ব্যর্থ। অনুগ্রহ করে আবার চেষ্টা করুন।';
                    $message_type = 'danger';
                }
            }
        } elseif ($action === 'upload_certificate') {
            $cert_type = $_POST['cert_type'];

            if (isset($_FILES['certificate']) && $_FILES['certificate']['error'] === UPLOAD_ERR_OK) {
                $file_tmp = $_FILES['certificate']['tmp_name'];
                $file_name = $_FILES['certificate']['name'];
                $file_ext = strtolower(pathinfo($file_name, PATHINFO_EXTENSION));

                // Validate file type
                $allowed_exts = ['jpg', 'jpeg', 'png', 'pdf'];
                if (!in_array($file_ext, $allowed_exts)) {
                    $message = 'শুধুমাত্র JPG, PNG, PDF ফাইল আপলোড করা যাবে';
                    $message_type = 'danger';
                } else {
                    // Generate unique filename
                    $new_filename = $cert_type . '_' . time() . '.' . $file_ext;
                    $file_path = $upload_dir . $new_filename;

                        if (move_uploaded_file($file_tmp, $file_path)) {
                            // Update database
                            $key_map = [
                                'private_limited' => 'private_limited_cert',
                                'trade_license' => 'trade_license_cert',
                                'tin_cert' => 'tin_cert'
                            ];

                            $key_name = $key_map[$cert_type];
                            $stmt = $conn->prepare("INSERT INTO settings (key_name, value) VALUES (?, ?) ON DUPLICATE KEY UPDATE value = ?");
                            $stmt->bind_param("sss", $key_name, $new_filename, $new_filename);

                            if ($stmt->execute()) {
                                $message = 'সার্টিফিকেট সফলভাবে আপলোড করা হয়েছে';
                                $message_type = 'success';
                            } else {
                                // Delete the uploaded file if database update failed
                                unlink($file_path);
                                $message = 'ডাটাবেস আপডেট করতে ব্যর্থ। অনুগ্রহ করে আবার চেষ্টা করুন।';
                                $message_type = 'danger';
                            }
                        } else {
                            $message = 'ফাইল আপলোড করতে ব্যর্থ';
                            $message_type = 'danger';
                        }
                }
            } else {
                $message = 'ফাইল সিলেক্ট করুন';
                $message_type = 'danger';
            }
        }
    }
}

// Get current settings
$withdrawal_fee = get_setting('withdrawal_fee') ?: '0';
$private_limited_cert = get_setting('private_limited_cert');
$trade_license_cert = get_setting('trade_license_cert');
$tin_cert = get_setting('tin_cert');

// Debug output
if (isset($_GET['debug'])) {
    echo "<div class='alert alert-info'>";
    echo "<strong>Debug Info:</strong><br>";
    echo "private_limited_cert: '" . $private_limited_cert . "'<br>";
    echo "trade_license_cert: '" . $trade_license_cert . "'<br>";
    echo "tin_cert: '" . $tin_cert . "'<br>";
    echo "</div>";
}

// Get referral settings
$stmt = $conn->prepare("SELECT * FROM referral_settings ORDER BY level");
$stmt->execute();
$referral_settings = $stmt->get_result();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>সেটিংস - অ্যাডমিন প্যানেল - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/admin_navbar.php'; ?>

    <div class="container mt-4">
        <h2 class="mb-4"><i class="fas fa-cog"></i> সেটিংস</h2>

        <!-- Message Display -->
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type; ?> alert-dismissible fade show" role="alert">
                <?php echo $message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Withdrawal Fee Settings -->
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-money-bill-wave"></i> উইথড্রয়াল ফি সেটিংস</h5>
            </div>
            <div class="card-body">
                <form method="POST" accept-charset="UTF-8">
                    <input type="hidden" name="action" value="update_settings">
                    <div class="row">
                        <div class="col-md-6">
                            <label class="form-label">উইথড্রয়াল ফি (%)</label>
                            <input type="number" class="form-control" name="withdrawal_fee" value="<?php echo $withdrawal_fee; ?>" step="0.01" min="0" max="100" required>
                            <div class="form-text">উইথড্রয়াল এর সময় কাটা হবে এই শতাংশ</div>
                        </div>
                    </div>
                    <button type="submit" class="btn btn-primary mt-3">
                        <i class="fas fa-save"></i> সেটিংস আপডেট করুন
                    </button>
                </form>
            </div>
        </div>

        <!-- Referral Commission Settings -->
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-users"></i> রেফারেল কমিশন সেটিংস</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">রেফারেল কমিশনের শতাংশ নির্ধারণ করুন</p>
                <form method="POST" accept-charset="UTF-8">
                    <input type="hidden" name="action" value="update_referral_settings">
                    <div class="row">
                        <?php while ($setting = $referral_settings->fetch_assoc()): ?>
                        <div class="col-md-4 mb-3">
                            <label class="form-label">লেভেল <?php echo $setting['level']; ?> কমিশন (%)</label>
                            <input type="number" class="form-control" name="commission[<?php echo $setting['level']; ?>]" value="<?php echo $setting['commission_percentage']; ?>" step="0.01" min="0" max="100" required>
                        </div>
                        <?php endwhile; ?>
                    </div>
                    <button type="submit" class="btn btn-success mt-3">
                        <i class="fas fa-save"></i> রেফারেল সেটিংস আপডেট করুন
                    </button>
                </form>
            </div>
        </div>

        <!-- Certificate Upload -->
        <div class="card mb-4">
            <div class="card-header">
                <h5><i class="fas fa-certificate"></i> সার্টিফিকেট আপলোড</h5>
            </div>
            <div class="card-body">
                <p class="text-muted">এই সার্টিফিকেটগুলো About পেজে প্রদর্শিত হবে</p>

                <div class="row">
                    <!-- Private Limited Company Certificate -->
                    <div class="col-md-4 mb-3">
                        <div class="card h-100">
                            <div class="card-header">
                                <h6 class="mb-0">Private Limited Company</h6>
                            </div>
                            <div class="card-body text-center">
                                <?php if ($private_limited_cert): ?>
                                    <div class="mb-3">
                                        <?php
                                        $file_ext = strtolower(pathinfo($private_limited_cert, PATHINFO_EXTENSION));
                                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                                            echo '<img src="../uploads/certificates/' . htmlspecialchars($private_limited_cert) . '" class="img-fluid mb-2" style="max-height: 150px;">';
                                        } else {
                                            echo '<i class="fas fa-file-pdf fa-3x text-danger mb-2"></i>';
                                        }
                                        ?>
                                        <br>
                                        <small class="text-muted">আপলোড করা হয়েছে</small>
                                    </div>
                                <?php endif; ?>

                                <form method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="action" value="upload_certificate">
                                    <input type="hidden" name="cert_type" value="private_limited">
                                    <div class="mb-2">
                                        <input type="file" class="form-control form-control-sm" name="certificate" accept=".jpg,.jpeg,.png,.pdf" required>
                                    </div>
                                    <button type="submit" class="btn btn-sm btn-primary">
                                        <i class="fas fa-upload"></i> আপলোড
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- Trade License Certificate -->
                    <div class="col-md-4 mb-3">
                        <div class="card h-100">
                            <div class="card-header">
                                <h6 class="mb-0">Trade License</h6>
                            </div>
                            <div class="card-body text-center">
                                <?php if ($trade_license_cert): ?>
                                    <div class="mb-3">
                                        <?php
                                        $file_ext = strtolower(pathinfo($trade_license_cert, PATHINFO_EXTENSION));
                                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                                            echo '<img src="../uploads/certificates/' . htmlspecialchars($trade_license_cert) . '" class="img-fluid mb-2" style="max-height: 150px;">';
                                        } else {
                                            echo '<i class="fas fa-file-pdf fa-3x text-danger mb-2"></i>';
                                        }
                                        ?>
                                        <br>
                                        <small class="text-muted">আপলোড করা হয়েছে</small>
                                    </div>
                                <?php endif; ?>

                                <form method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="action" value="upload_certificate">
                                    <input type="hidden" name="cert_type" value="trade_license">
                                    <div class="mb-2">
                                        <input type="file" class="form-control form-control-sm" name="certificate" accept=".jpg,.jpeg,.png,.pdf" required>
                                    </div>
                                    <button type="submit" class="btn btn-sm btn-primary">
                                        <i class="fas fa-upload"></i> আপলোড
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>

                    <!-- TIN Certificate -->
                    <div class="col-md-4 mb-3">
                        <div class="card h-100">
                            <div class="card-header">
                                <h6 class="mb-0">TIN Certificate</h6>
                            </div>
                            <div class="card-body text-center">
                                <?php if ($tin_cert): ?>
                                    <div class="mb-3">
                                        <?php
                                        $file_ext = strtolower(pathinfo($tin_cert, PATHINFO_EXTENSION));
                                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                                            echo '<img src="../uploads/certificates/' . htmlspecialchars($tin_cert) . '" class="img-fluid mb-2" style="max-height: 150px;">';
                                        } else {
                                            echo '<i class="fas fa-file-pdf fa-3x text-danger mb-2"></i>';
                                        }
                                        ?>
                                        <br>
                                        <small class="text-muted">আপলোড করা হয়েছে</small>
                                    </div>
                                <?php endif; ?>

                                <form method="POST" enctype="multipart/form-data">
                                    <input type="hidden" name="action" value="upload_certificate">
                                    <input type="hidden" name="cert_type" value="tin_cert">
                                    <div class="mb-2">
                                        <input type="file" class="form-control form-control-sm" name="certificate" accept=".jpg,.jpeg,.png,.pdf" required>
                                    </div>
                                    <button type="submit" class="btn btn-sm btn-primary">
                                        <i class="fas fa-upload"></i> আপলোড
                                    </button>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Current Certificate Previews -->
        <?php if ($private_limited_cert || $trade_license_cert || $tin_cert): ?>
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-eye"></i> বর্তমান সার্টিফিকেট প্রিভিউ</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php if ($private_limited_cert): ?>
                    <div class="col-md-4 text-center mb-3">
                        <h6>Private Limited Company</h6>
                        <?php
                        $file_ext = strtolower(pathinfo($private_limited_cert, PATHINFO_EXTENSION));
                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                            echo '<img src="../uploads/certificates/' . htmlspecialchars($private_limited_cert) . '" class="img-fluid" style="max-height: 200px;">';
                        } else {
                            echo '<a href="../uploads/certificates/' . htmlspecialchars($private_limited_cert) . '" target="_blank" class="btn btn-outline-primary"><i class="fas fa-file-pdf"></i> PDF দেখুন</a>';
                        }
                        ?>
                    </div>
                    <?php endif; ?>

                    <?php if ($trade_license_cert): ?>
                    <div class="col-md-4 text-center mb-3">
                        <h6>Trade License</h6>
                        <?php
                        $file_ext = strtolower(pathinfo($trade_license_cert, PATHINFO_EXTENSION));
                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                            echo '<img src="../uploads/certificates/' . htmlspecialchars($trade_license_cert) . '" class="img-fluid" style="max-height: 200px;">';
                        } else {
                            echo '<a href="../uploads/certificates/' . htmlspecialchars($trade_license_cert) . '" target="_blank" class="btn btn-outline-primary"><i class="fas fa-file-pdf"></i> PDF দেখুন</a>';
                        }
                        ?>
                    </div>
                    <?php endif; ?>

                    <?php if ($tin_cert): ?>
                    <div class="col-md-4 text-center mb-3">
                        <h6>TIN Certificate</h6>
                        <?php
                        $file_ext = strtolower(pathinfo($tin_cert, PATHINFO_EXTENSION));
                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                            echo '<img src="../uploads/certificates/' . htmlspecialchars($tin_cert) . '" class="img-fluid" style="max-height: 200px;">';
                        } else {
                            echo '<a href="../uploads/certificates/' . htmlspecialchars($tin_cert) . '" target="_blank" class="btn btn-outline-primary"><i class="fas fa-file-pdf"></i> PDF দেখুন</a>';
                        }
                        ?>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
