<?php
header('Content-Type: text/html; charset=UTF-8');
require_once '../includes/config.php';

// Simple admin check
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

// Handle form submissions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];

        if ($action === 'add_notice') {
            $title = trim($_POST['title']);
            $message_text = trim($_POST['message']);

            if (empty($title) || empty($message_text)) {
                $message = 'সব ফিল্ড পূরণ করুন';
                $message_type = 'danger';
            } else {
                if (add_notice($title, $message_text)) {
                    $message = 'নোটিশ সফলভাবে যোগ করা হয়েছে';
                    $message_type = 'success';
                } else {
                    $message = 'নোটিশ যোগ করতে ব্যর্থ';
                    $message_type = 'danger';
                }
            }
        } elseif ($action === 'update_notice') {
            $id = (int)$_POST['id'];
            $title = trim($_POST['title']);
            $message_text = trim($_POST['message']);
            $is_active = isset($_POST['is_active']) ? 1 : 0;

            if (empty($title) || empty($message_text)) {
                $message = 'সব ফিল্ড পূরণ করুন';
                $message_type = 'danger';
            } else {
                if (update_notice($id, $title, $message_text, $is_active)) {
                    $message = 'নোটিশ সফলভাবে আপডেট করা হয়েছে';
                    $message_type = 'success';
                } else {
                    $message = 'নোটিশ আপডেট করতে ব্যর্থ';
                    $message_type = 'danger';
                }
            }
        } elseif ($action === 'delete_notice') {
            $id = (int)$_POST['id'];

            if (delete_notice($id)) {
                $message = 'নোটিশ সফলভাবে মুছে ফেলা হয়েছে';
                $message_type = 'success';
            } else {
                $message = 'নোটিশ মুছে ফেলতে ব্যর্থ';
                $message_type = 'danger';
            }
        }
    }
}

// Get all notices
$notices = get_all_notices();
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>নোটিশ ম্যানেজমেন্ট - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/admin_navbar.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-bullhorn"></i> নোটিশ ম্যানেজমেন্ট</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addNoticeModal">
                <i class="fas fa-plus"></i> নতুন নোটিশ যোগ করুন
            </button>
        </div>

        <!-- Message Display -->
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type; ?> alert-dismissible fade show" role="alert">
                <?php echo $message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <?php
            $stmt = $conn->prepare("SELECT COUNT(*) as total_notices FROM notices");
            $stmt->execute();
            $total_notices = $stmt->get_result()->fetch_assoc()['total_notices'];

            $stmt = $conn->prepare("SELECT COUNT(*) as active_notices FROM notices WHERE is_active = 1");
            $stmt->execute();
            $active_notices = $stmt->get_result()->fetch_assoc()['active_notices'];

            $stmt = $conn->prepare("SELECT COUNT(*) as inactive_notices FROM notices WHERE is_active = 0");
            $stmt->execute();
            $inactive_notices = $stmt->get_result()->fetch_assoc()['inactive_notices'];
            ?>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h4 class="text-primary"><?php echo $total_notices; ?></h4>
                        <p>মোট নোটিশ</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h4 class="text-success"><?php echo $active_notices; ?></h4>
                        <p>অ্যাক্টিভ নোটিশ</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h4 class="text-warning"><?php echo $inactive_notices; ?></h4>
                        <p>ইনঅ্যাক্টিভ নোটিশ</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Notices List -->
        <div class="card">
            <div class="card-header">
                <h5><i class="fas fa-list"></i> নোটিশ তালিকা</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>টাইটেল</th>
                                <th>মেসেজ</th>
                                <th>স্ট্যাটাস</th>
                                <th>তারিখ</th>
                                <th>অ্যাকশন</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php while ($notice = $notices->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($notice['title']); ?></td>
                                    <td><?php echo htmlspecialchars(substr($notice['message'], 0, 100)) . (strlen($notice['message']) > 100 ? '...' : ''); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $notice['is_active'] ? 'success' : 'secondary'; ?>">
                                            <?php echo $notice['is_active'] ? 'অ্যাক্টিভ' : 'ইনঅ্যাক্টিভ'; ?>
                                        </span>
                                    </td>
                                    <td><?php echo date('d/m/Y H:i', strtotime($notice['created_at'])); ?></td>
                                    <td>
                                        <button class="btn btn-sm btn-primary me-1" onclick="editNotice(<?php echo $notice['id']; ?>, '<?php echo addslashes($notice['title']); ?>', '<?php echo addslashes($notice['message']); ?>', <?php echo $notice['is_active']; ?>)">
                                            <i class="fas fa-edit"></i>
                                        </button>
                                        <button class="btn btn-sm btn-danger" onclick="deleteNotice(<?php echo $notice['id']; ?>)">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                </tr>
                            <?php endwhile; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Notice Modal -->
    <div class="modal fade" id="addNoticeModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">নতুন নোটিশ যোগ করুন</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" accept-charset="UTF-8">
                        <input type="hidden" name="action" value="add_notice">
                        <div class="mb-3">
                            <label class="form-label">টাইটেল</label>
                            <input type="text" class="form-control" name="title" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">মেসেজ</label>
                            <textarea class="form-control" name="message" rows="5" required></textarea>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">বাতিল</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-plus"></i> যোগ করুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Notice Modal -->
    <div class="modal fade" id="editNoticeModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">নোটিশ এডিট করুন</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" accept-charset="UTF-8" id="editNoticeForm">
                        <input type="hidden" name="action" value="update_notice">
                        <input type="hidden" name="id" id="editNoticeId">
                        <div class="mb-3">
                            <label class="form-label">টাইটেল</label>
                            <input type="text" class="form-control" name="title" id="editNoticeTitle" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">মেসেজ</label>
                            <textarea class="form-control" name="message" id="editNoticeMessage" rows="5" required></textarea>
                        </div>
                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" name="is_active" id="editNoticeActive">
                            <label class="form-check-label" for="editNoticeActive">অ্যাক্টিভ</label>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">বাতিল</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> আপডেট করুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteNoticeModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">নোটিশ মুছে ফেলুন</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>আপনি কি নিশ্চিত যে এই নোটিশটি মুছে ফেলতে চান?</p>
                    <div class="alert alert-warning">
                        <strong>সতর্কতা:</strong> এই অ্যাকশন রিভার্স করা যাবে না।
                    </div>
                    <form method="POST" accept-charset="UTF-8" id="deleteNoticeForm">
                        <input type="hidden" name="action" value="delete_notice">
                        <input type="hidden" name="id" id="deleteNoticeId">
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">বাতিল</button>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash"></i> মুছে ফেলুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function editNotice(id, title, message, isActive) {
            document.getElementById('editNoticeId').value = id;
            document.getElementById('editNoticeTitle').value = title;
            document.getElementById('editNoticeMessage').value = message;
            document.getElementById('editNoticeActive').checked = isActive;

            const modal = new bootstrap.Modal(document.getElementById('editNoticeModal'));
            modal.show();
        }

        function deleteNotice(id) {
            document.getElementById('deleteNoticeId').value = id;

            const modal = new bootstrap.Modal(document.getElementById('deleteNoticeModal'));
            modal.show();
        }
    </script>
</body>
</html>
