<?php
header('Content-Type: text/html; charset=UTF-8');
header('Content-Language: bn');
mb_internal_encoding('UTF-8');
mb_http_output('UTF-8');
mb_regex_encoding('UTF-8');
require_once '../includes/config.php';

// Simple admin check
session_start();
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: index.php");
    exit();
}

// Handle form submissions
$message = '';
$message_type = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        $action = $_POST['action'];

        if ($action === 'add_method') {
            $name = trim($_POST['name']);
            $number = trim($_POST['number']);
            $type = $_POST['type'];
            $instructions = trim($_POST['instructions']);

            $validation_error = false;
            if (empty($name) || empty($type)) {
                $validation_error = true;
            } elseif ($type === 'deposit' && empty($number)) {
                $validation_error = true;
            }

            if ($validation_error) {
                $message = 'সব প্রয়োজনীয় ফিল্ড পূরণ করুন';
                $message_type = 'danger';
            } else {
                $stmt = $conn->prepare("INSERT INTO payment_methods (name, number, type, instructions) VALUES (?, ?, ?, ?)");
                $stmt->bind_param("ssss", $name, $number, $type, $instructions);
                if ($stmt->execute()) {
                    $message = 'পেমেন্ট মেথড সফলভাবে যোগ করা হয়েছে';
                    $message_type = 'success';
                } else {
                    $message = 'পেমেন্ট মেথড যোগ করতে ব্যর্থ';
                    $message_type = 'danger';
                }
            }
        } elseif ($action === 'update_method') {
            $id = (int)$_POST['method_id'];
            $name = trim($_POST['name']);
            $number = trim($_POST['number']);
            $type = $_POST['type'];
            $instructions = trim($_POST['instructions']);
            $is_active = isset($_POST['is_active']) ? 1 : 0;

            $validation_error = false;
            if (empty($name) || empty($type)) {
                $validation_error = true;
            } elseif ($type === 'deposit' && empty($number)) {
                $validation_error = true;
            }

            if ($validation_error) {
                $message = 'সব প্রয়োজনীয় ফিল্ড পূরণ করুন';
                $message_type = 'danger';
            } else {
                $stmt = $conn->prepare("UPDATE payment_methods SET name = ?, number = ?, type = ?, instructions = ?, is_active = ? WHERE id = ?");
                $stmt->bind_param("ssssii", $name, $number, $type, $instructions, $is_active, $id);
                if ($stmt->execute()) {
                    $message = 'পেমেন্ট মেথড সফলভাবে আপডেট করা হয়েছে';
                    $message_type = 'success';
                } else {
                    $message = 'পেমেন্ট মেথড আপডেট করতে ব্যর্থ';
                    $message_type = 'danger';
                }
            }
        } elseif ($action === 'delete_method') {
            $id = (int)$_POST['method_id'];

            $stmt = $conn->prepare("DELETE FROM payment_methods WHERE id = ?");
            $stmt->bind_param("i", $id);
            if ($stmt->execute()) {
                $message = 'পেমেন্ট মেথড সফলভাবে মুছে ফেলা হয়েছে';
                $message_type = 'success';
            } else {
                $message = 'পেমেন্ট মেথড মুছে ফেলতে ব্যর্থ';
                $message_type = 'danger';
            }
        }
    }
}

// Get all payment methods
$stmt = $conn->prepare("SELECT * FROM payment_methods ORDER BY type, name");
$payment_methods = $stmt->execute() ? $stmt->get_result() : null;

// Get statistics
$deposit_methods_count = 0;
$withdrawal_methods_count = 0;
$active_methods_count = 0;

if ($payment_methods) {
    while ($method = $payment_methods->fetch_assoc()) {
        if ($method['type'] === 'deposit') $deposit_methods_count++;
        if ($method['type'] === 'withdrawal') $withdrawal_methods_count++;
        if ($method['is_active']) $active_methods_count++;
    }
    $payment_methods->data_seek(0); // Reset pointer
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>পেমেন্ট মেথড ম্যানেজমেন্ট - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/admin_navbar.php'; ?>

    <div class="container mt-4">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-credit-card"></i> পেমেন্ট মেথড ম্যানেজমেন্ট</h2>
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addMethodModal">
                <i class="fas fa-plus"></i> নতুন মেথড যোগ করুন
            </button>
        </div>

        <!-- Message Display -->
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $message_type; ?> alert-dismissible fade show" role="alert">
                <?php echo $message; ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h4 class="text-primary"><?php echo $deposit_methods_count; ?></h4>
                        <p>ডিপোজিট মেথড</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h4 class="text-success"><?php echo $withdrawal_methods_count; ?></h4>
                        <p>উইথড্রয়াল মেথড</p>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="card text-center">
                    <div class="card-body">
                        <h4 class="text-info"><?php echo $active_methods_count; ?></h4>
                        <p>অ্যাক্টিভ মেথড</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Payment Methods Table -->
        <div class="card">
            <div class="card-header">
                <h5>পেমেন্ট মেথড তালিকা</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead class="table-dark">
                            <tr>
                                <th>আইডি</th>
                                <th>নাম</th>
                                <th>নাম্বার</th>
                                <th>টাইপ</th>
                                <th>ইন্সট্রাকশন</th>
                                <th>স্ট্যাটাস</th>
                                <th>অ্যাকশন</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if ($payment_methods && $payment_methods->num_rows > 0): ?>
                                <?php while ($method = $payment_methods->fetch_assoc()): ?>
                                <tr>
                                    <td><?php echo $method['id']; ?></td>
                                    <td><?php echo htmlspecialchars($method['name']); ?></td>
                                    <td><?php echo htmlspecialchars($method['number']); ?></td>
                                    <td>
                                        <span class="badge bg-<?php echo $method['type'] === 'deposit' ? 'primary' : 'success'; ?>">
                                            <?php echo $method['type'] === 'deposit' ? 'ডিপোজিট' : 'উইথড্রয়াল'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <?php echo $method['instructions'] ? htmlspecialchars(substr($method['instructions'], 0, 50)) . (strlen($method['instructions']) > 50 ? '...' : '') : '<em class="text-muted">কোন ইন্সট্রাকশন নেই</em>'; ?>
                                    </td>
                                    <td>
                                        <span class="badge bg-<?php echo $method['is_active'] ? 'success' : 'secondary'; ?>">
                                            <?php echo $method['is_active'] ? 'অ্যাক্টিভ' : 'ইনঅ্যাক্টিভ'; ?>
                                        </span>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-primary" onclick="editMethod(<?php echo $method['id']; ?>, '<?php echo addslashes($method['name']); ?>', '<?php echo addslashes($method['number']); ?>', '<?php echo $method['type']; ?>', '<?php echo addslashes($method['instructions']); ?>', <?php echo $method['is_active']; ?>)">
                                                <i class="fas fa-edit"></i>
                                            </button>
                                            <button class="btn btn-sm btn-danger" onclick="deleteMethod(<?php echo $method['id']; ?>, '<?php echo addslashes($method['name']); ?>')">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                    </td>
                                </tr>
                                <?php endwhile; ?>
                            <?php else: ?>
                                <tr>
                                    <td colspan="7" class="text-center text-muted">কোন পেমেন্ট মেথড পাওয়া যায়নি</td>
                                </tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Add Method Modal -->
    <div class="modal fade" id="addMethodModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">নতুন পেমেন্ট মেথড যোগ করুন</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" accept-charset="UTF-8">
                        <input type="hidden" name="action" value="add_method">
                        <div class="mb-3">
                            <label class="form-label">মেথড নাম</label>
                            <input type="text" class="form-control" name="name" placeholder="যেমন: বিকাশ, নগদ, ব্যাংক" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">অ্যাকাউন্ট নাম্বার</label>
                            <input type="text" class="form-control" name="number" id="addMethodNumber" placeholder="অ্যাকাউন্ট নাম্বার বা মোবাইল নাম্বার" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">টাইপ</label>
                            <select class="form-control" name="type" id="addMethodType" required>
                                <option value="deposit">ডিপোজিট</option>
                                <option value="withdrawal">উইথড্রয়াল</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">পেমেন্ট ইন্সট্রাকশন</label>
                            <textarea class="form-control" name="instructions" id="addMethodInstructions" rows="4" placeholder="কিভাবে পেমেন্ট করতে হবে তার বিস্তারিত নির্দেশনা..."></textarea>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">বাতিল</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-plus"></i> যোগ করুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Edit Method Modal -->
    <div class="modal fade" id="editMethodModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">পেমেন্ট মেথড এডিট করুন</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <form method="POST" accept-charset="UTF-8" id="editMethodForm">
                        <input type="hidden" name="action" value="update_method">
                        <input type="hidden" name="method_id" id="editMethodId">
                        <div class="mb-3">
                            <label class="form-label">মেথড নাম</label>
                            <input type="text" class="form-control" name="name" id="editMethodName" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">অ্যাকাউন্ট নাম্বার</label>
                            <input type="text" class="form-control" name="number" id="editMethodNumber" required>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">টাইপ</label>
                            <select class="form-control" name="type" id="editMethodType" required>
                                <option value="deposit">ডিপোজিট</option>
                                <option value="withdrawal">উইথড্রয়াল</option>
                            </select>
                        </div>
                        <div class="mb-3">
                            <label class="form-label">পেমেন্ট ইন্সট্রাকশন</label>
                            <textarea class="form-control" name="instructions" id="editMethodInstructions" rows="4"></textarea>
                        </div>
                        <div class="mb-3 form-check">
                            <input type="checkbox" class="form-check-input" name="is_active" id="editMethodActive">
                            <label class="form-check-label" for="editMethodActive">অ্যাক্টিভ</label>
                        </div>
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">বাতিল</button>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> আপডেট করুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Delete Confirmation Modal -->
    <div class="modal fade" id="deleteMethodModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">পেমেন্ট মেথড মুছে ফেলুন</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <p>আপনি কি নিশ্চিত যে <strong id="deleteMethodName"></strong> মেথডটি মুছে ফেলতে চান?</p>
                    <div class="alert alert-warning">
                        <strong>সতর্কতা:</strong> এই অ্যাকশন রিভার্স করা যাবে না। এই মেথড ব্যবহার করে কোন ট্রানজেকশন থাকলে সেগুলো অসম্পূর্ণ থাকবে।
                    </div>
                    <form method="POST" accept-charset="UTF-8" id="deleteMethodForm">
                        <input type="hidden" name="action" value="delete_method">
                        <input type="hidden" name="method_id" id="deleteMethodId">
                        <div class="d-flex justify-content-end">
                            <button type="button" class="btn btn-secondary me-2" data-bs-dismiss="modal">বাতিল</button>
                            <button type="submit" class="btn btn-danger">
                                <i class="fas fa-trash"></i> মুছে ফেলুন
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize add modal with deposit fields visible
            toggleMethodFields('deposit', 'add');
        });

        function toggleMethodFields(type, prefix) {
            const numberField = document.getElementById(prefix + 'MethodNumber');
            const instructionsField = document.getElementById(prefix + 'MethodInstructions');

            if (type === 'withdrawal') {
                // Hide number and instructions for withdrawal
                numberField.closest('.mb-3').style.display = 'none';
                instructionsField.closest('.mb-3').style.display = 'none';
                numberField.required = false;
                instructionsField.required = false;
            } else {
                // Show for deposit
                numberField.closest('.mb-3').style.display = 'block';
                instructionsField.closest('.mb-3').style.display = 'block';
                numberField.required = true;
                instructionsField.required = false; // Instructions are optional
            }
        }

        // Event listeners for type changes
        document.getElementById('addMethodType').addEventListener('change', function() {
            toggleMethodFields(this.value, 'add');
        });

        document.getElementById('editMethodType').addEventListener('change', function() {
            toggleMethodFields(this.value, 'edit');
        });

        function editMethod(id, name, number, type, instructions, isActive) {
            document.getElementById('editMethodId').value = id;
            document.getElementById('editMethodName').value = name;
            document.getElementById('editMethodNumber').value = number;
            document.getElementById('editMethodType').value = type;
            document.getElementById('editMethodInstructions').value = instructions;
            document.getElementById('editMethodActive').checked = isActive;

            // Apply field visibility based on type
            toggleMethodFields(type, 'edit');

            const modal = new bootstrap.Modal(document.getElementById('editMethodModal'));
            modal.show();
        }

        function deleteMethod(id, name) {
            document.getElementById('deleteMethodId').value = id;
            document.getElementById('deleteMethodName').textContent = name;

            const modal = new bootstrap.Modal(document.getElementById('deleteMethodModal'));
            modal.show();
        }
    </script>
</body>
</html>
