<?php
require_once '../includes/config.php';

// Simple admin check
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    header("Location: index.php");
    exit();
}
?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>অ্যাডমিন ড্যাশবোর্ড - <?php echo $company_name; ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body>
    <?php include '../includes/admin_navbar.php'; ?>

    <div class="container mt-4">
        <h2 class="mb-4">অ্যাডমিন ড্যাশবোর্ড</h2>

        <!-- Statistics Cards -->
        <div class="row mb-4">
            <?php
            // Get statistics
            $stmt = $conn->prepare("SELECT COUNT(*) as total_users FROM users");
            $stmt->execute();
            $total_users = $stmt->get_result()->fetch_assoc()['total_users'];

            $stmt = $conn->prepare("SELECT COUNT(*) as total_companies FROM companies");
            $stmt->execute();
            $total_companies = $stmt->get_result()->fetch_assoc()['total_companies'];

            $stmt = $conn->prepare("SELECT COUNT(*) as pending_deposits FROM transactions WHERE status = 'pending' AND type = 'deposit'");
            $stmt->execute();
            $pending_deposits = $stmt->get_result()->fetch_assoc()['pending_deposits'];

            $stmt = $conn->prepare("SELECT COUNT(*) as pending_withdrawals FROM transactions WHERE status = 'pending' AND type = 'withdrawal'");
            $stmt->execute();
            $pending_withdrawals = $stmt->get_result()->fetch_assoc()['pending_withdrawals'];

            $stmt = $conn->prepare("SELECT COUNT(*) as approved_withdrawals FROM transactions WHERE status = 'approved' AND type = 'withdrawal'");
            $stmt->execute();
            $approved_withdrawals = $stmt->get_result()->fetch_assoc()['approved_withdrawals'];

            $stmt = $conn->prepare("SELECT SUM(balance) as total_balance FROM users");
            $stmt->execute();
            $total_balance = $stmt->get_result()->fetch_assoc()['total_balance'] ?: 0;

            $stmt = $conn->prepare("SELECT SUM(amount) as total_withdrawal_balance FROM transactions WHERE status = 'approved' AND type = 'withdrawal'");
            $stmt->execute();
            $total_withdrawal_balance = $stmt->get_result()->fetch_assoc()['total_withdrawal_balance'] ?: 0;

            $stmt = $conn->prepare("SELECT SUM(amount) as total_deposit_balance FROM transactions WHERE status = 'approved' AND type = 'deposit'");
            $stmt->execute();
            $total_deposit_balance = $stmt->get_result()->fetch_assoc()['total_deposit_balance'] ?: 0;
            ?>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-primary"><?php echo $total_users; ?></h5>
                        <p class="mb-0">মোট ইউজার</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-success"><?php echo $total_companies; ?></h5>
                        <p class="mb-0">মোট কোম্পানি</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-warning"><?php echo $pending_deposits; ?></h5>
                        <p class="mb-0">পেন্ডিং ডিপোজিট</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-danger"><?php echo $pending_withdrawals; ?></h5>
                        <p class="mb-0">পেন্ডিং উইথড্রয়াল</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-info"><?php echo $approved_withdrawals; ?></h5>
                        <p class="mb-0">অনুমোদিত উইথড্রয়াল</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-secondary"><?php echo format_currency($total_balance); ?></h5>
                        <p class="mb-0">প্ল্যাটফর্ম ব্যালেন্স</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-warning"><?php echo format_currency($total_withdrawal_balance); ?></h5>
                        <p class="mb-0">মোট উইথড্রয়াল ব্যালেন্স</p>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="card text-center">
                    <div class="card-body">
                        <h5 class="text-success"><?php echo format_currency($total_deposit_balance); ?></h5>
                        <p class="mb-0">মোট ডিপোজিট অনুমোদিত ব্যালেন্স</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Transactions -->
        <div class="card mb-4">
            <div class="card-header">
                <h5>সাম্প্রতিক ট্রানজেকশন</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>ইউজার</th>
                                <th>টাইপ</th>
                                <th>পরিমান</th>
                                <th>স্ট্যাটাস</th>
                                <th>তারিখ</th>
                                <th>অ্যাকশন</th>
                            </tr>
                        </thead>
                        <tbody id="recentTransactions">
                            <?php
                            $stmt = $conn->prepare("SELECT t.*, u.full_name FROM transactions t JOIN users u ON t.user_id = u.id ORDER BY t.created_at DESC LIMIT 10");
                            $stmt->execute();
                            $transactions = $stmt->get_result();

                            while ($transaction = $transactions->fetch_assoc()) {
                                $status_badge = '';
                                switch ($transaction['status']) {
                                    case 'pending':
                                        $status_badge = '<span class="badge bg-warning">পেন্ডিং</span>';
                                        break;
                                    case 'approved':
                                        $status_badge = '<span class="badge bg-success">অনুমোদিত</span>';
                                        break;
                                    case 'rejected':
                                        $status_badge = '<span class="badge bg-danger">প্রত্যাখ্যাত</span>';
                                        break;
                                }

                                $action_buttons = '';
                                if ($transaction['status'] === 'pending') {
                                    $action_buttons = '
                                        <button class="btn btn-sm btn-success" onclick="approveTransaction(' . $transaction['id'] . ')">অনুমোদন</button>
                                        <button class="btn btn-sm btn-danger" onclick="rejectTransaction(' . $transaction['id'] . ')">প্রত্যাখ্যান</button>
                                    ';
                                }

                                echo "
                                    <tr>
                                        <td>{$transaction['full_name']}</td>
                                        <td>{$transaction['type']}</td>
                                        <td>" . format_currency($transaction['amount']) . "</td>
                                        <td>{$status_badge}</td>
                                        <td>" . date('d/m/Y H:i', strtotime($transaction['created_at'])) . "</td>
                                        <td>{$action_buttons}</td>
                                    </tr>
                                ";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Recent Users -->
        <div class="card">
            <div class="card-header">
                <h5>নতুন ইউজার</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>নাম</th>
                                <th>ইমেইল</th>
                                <th>ফোন</th>
                                <th>ব্যালেন্স</th>
                                <th>যোগদানের তারিখ</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $stmt = $conn->prepare("SELECT * FROM users ORDER BY created_at DESC LIMIT 5");
                            $stmt->execute();
                            $users = $stmt->get_result();

                            while ($user = $users->fetch_assoc()) {
                                echo "
                                    <tr>
                                        <td>{$user['full_name']}</td>
                                        <td>{$user['email']}</td>
                                        <td>{$user['phone']}</td>
                                        <td>" . format_currency($user['balance']) . "</td>
                                        <td>" . date('d/m/Y', strtotime($user['created_at'])) . "</td>
                                    </tr>
                                ";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <!-- Success/Error Messages -->
    <div id="messageContainer" class="position-fixed top-0 end-0 p-3" style="z-index: 9999;"></div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/admin.js"></script>
</body>
</html>
