<?php
require_once '../../includes/config.php';

header('Content-Type: application/json');

// Check admin session
if (!isset($_SESSION['admin_logged_in']) || $_SESSION['admin_logged_in'] !== true) {
    echo json_encode(['success' => false, 'message' => 'অ্যাডমিন লগইন প্রয়োজন']);
    exit();
}

$transaction_id = (int)($_GET['id'] ?? 0);

if ($transaction_id <= 0) {
    echo json_encode(['success' => false, 'message' => 'অবৈধ ট্রানজেকশন আইডি']);
    exit();
}

$result = reject_transaction($transaction_id);

if ($result) {
    echo json_encode(['success' => true, 'message' => 'ট্রানজেকশন প্রত্যাখ্যাত হয়েছে']);
} else {
    echo json_encode(['success' => false, 'message' => 'ট্রানজেকশন প্রত্যাখ্যান ব্যর্থ']);
}
?>
