<?php include 'includes/config.php'; ?>
<!DOCTYPE html>
<html lang="bn">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>InvestPro | Premier Auto-Slider Portfolio</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Syne:wght@700;800&family=Inter:wght@400;600;700&family=Hind+Siliguri:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link href="assets/css/style.css" rel="stylesheet">

    <style>
        :root {
            --bg-dark: #002B2B;
            --accent-green: #00ffa3;
            --accent-blue: #0075ff;
            --border: rgba(255, 255, 255, 0.08);
            --glass: rgba(255, 255, 255, 0.03);
        }

        body {
            background-color: var(--bg-dark);
            color: #fff;
            font-family: 'Inter', 'Hind Siliguri', sans-serif;
            overflow-x: hidden;
        }

        /* --- Luxury Background --- */
        .aura-bg {
            position: fixed; top: 0; left: 0; width: 100%; height: 100%;
            background: radial-gradient(circle at 10% 20%, rgba(0, 255, 163, 0.05), transparent 40%),
                        radial-gradient(circle at 90% 80%, rgba(0, 117, 255, 0.05), transparent 40%);
            z-index: -1;
        }

        /* --- Ticker Styling --- */
        .section-header { margin-bottom: 50px; text-align: center; }
        .sector-tag { color: var(--accent-green); font-size: 12px; font-weight: 700; text-transform: uppercase; letter-spacing: 2px; }

        /* --- Horizontal Scroller (Infinite Side Move) --- */
        .scroller-container {
            width: 100%; overflow: hidden; padding: 40px 0;
            mask-image: linear-gradient(to right, transparent, black 15%, black 85%, transparent);
        }

        .scroller-track {
            display: flex; width: max-content; gap: 30px;
            animation: sideMove 40s linear infinite;
        }

        .scroller-container:hover .scroller-track {
            animation-play-state: paused;
        }

        @keyframes sideMove {
            0% { transform: translateX(0); }
            100% { transform: translateX(-50%); }
        }

        /* Touch support for mobile */
        @media (hover: none) and (pointer: coarse) {
            .scroller-container:hover .scroller-track {
                animation-play-state: running;
            }
        }

        /* Prevent horizontal scroll issues */
        * {
            box-sizing: border-box;
        }

        html, body {
            width: 100%;
            overflow-x: hidden;
        }

        /* Ensure containers don't cause horizontal scroll */
        .container {
            max-width: 100%;
            padding-left: 15px;
            padding-right: 15px;
        }

        @media (min-width: 576px) {
            .container {
                padding-left: 20px;
                padding-right: 20px;
            }
        }

        @media (min-width: 768px) {
            .container {
                padding-left: 25px;
                padding-right: 25px;
            }
        }

        @media (min-width: 992px) {
            .container {
                max-width: 960px;
            }
        }

        @media (min-width: 1200px) {
            .container {
                max-width: 1140px;
            }
        }

        /* Scroller improvements for mobile */
        .scroller-container {
            -webkit-overflow-scrolling: touch;
        }

        /* Better text rendering on mobile */
        body {
            -webkit-font-smoothing: antialiased;
            -moz-osx-font-smoothing: grayscale;
            text-rendering: optimizeLegibility;
        }

        /* Ensure images are responsive */
        .cert-img img {
            max-width: 100%;
            height: auto;
        }

        /* --- High Quality Bento Card --- */
        .stock-card {
            width: 300px; background: var(--glass); border: 1px solid var(--border);
            border-radius: 28px; padding: 25px; backdrop-filter: blur(10px);
            transition: all 0.4s cubic-bezier(0.165, 0.84, 0.44, 1);
            position: relative;
        }

        .stock-card:hover {
            border-color: var(--accent-green); background: rgba(255, 255, 255, 0.05);
            transform: scale(1.05);
        }

        .card-header-icon {
            width: 50px; height: 50px; background: #fff; border-radius: 12px;
            display: flex; align-items: center; justify-content: center;
            font-weight: 900; color: #000; font-size: 0.9rem; margin-bottom: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.4);
        }

        .price-val { font-size: 1.5rem; font-weight: 700; margin: 10px 0 5px; }
        .p-change { font-size: 0.85rem; font-weight: 600; }
        .p-up { color: var(--accent-green); }
        .p-down { color: #f43f5e; }

        /* --- Large Conglomerates Scroller --- */
        .large-scroller { background: #000; border-top: 1px solid var(--border); border-bottom: 1px solid var(--border); padding: 40px 0; margin-top: 50px; }
        .scrolling-text {
            font-size: 5rem; font-weight: 800; color: transparent;
            -webkit-text-stroke: 1px rgba(255,255,255,0.1); white-space: nowrap;
            animation: textMove 60s linear infinite; display: inline-block;
        }
        @keyframes textMove { 0% { transform: translateX(0); } 100% { transform: translateX(-50%); } }

        /* --- Premium Certificates --- */
        .cert-canvas {
            background: var(--glass); border: 1px solid var(--border);
            border-radius: 35px; padding: 20px; transition: 0.5s; text-align: center;
            height: 100%; min-height: 400px;
        }
        .cert-canvas:hover { border-color: var(--accent-blue); transform: translateY(-10px); }
        .cert-img {
            background: #fff; border-radius: 20px; height: 260px; overflow: hidden;
            display: flex; align-items: center; justify-content: center;
            margin-bottom: 15px;
        }
        .cert-img img { width: 90%; height: auto; max-height: 240px; object-fit: contain; }
        .cert-name { font-weight: 700; font-size: 1.3rem; margin-bottom: 10px; color: #fff; }

        .pdf-placeholder {
            display: flex; flex-direction: column; align-items: center; justify-content: center;
            height: 100%; min-height: 200px; color: #ff4444;
        }

        /* --- Mobile/Desktop Responsive --- */
        /* Tablet and Small Desktop */
        @media (max-width: 992px) {
            .scroller-container { padding: 30px 0; }
            .scroller-track { gap: 20px; }
            .stock-card { width: 280px; padding: 22px; }

            .large-scroller { padding: 30px 0; margin-top: 40px; }
            .scrolling-text { font-size: 4rem; }

            .cert-canvas { padding: 18px; min-height: 380px; }
            .cert-img { height: 240px; }
            .cert-img img { max-height: 220px; }
            .cert-name { font-size: 1.2rem; }

            .section-header { margin-bottom: 40px; }
            .display-3 { font-size: 2.2rem; }
            .py-100 { padding: 60px 0; }
        }

        /* Mobile Landscape and Tablet */
        @media (max-width: 768px) {
            .scroller-container { padding: 25px 0; }
            .scroller-track { gap: 15px; }
            .stock-card { width: 260px; padding: 20px; }

            .large-scroller { padding: 25px 0; margin-top: 35px; }
            .scrolling-text { font-size: 3.5rem; }

            .cert-canvas { padding: 16px; min-height: 360px; }
            .cert-img { height: 220px; }
            .cert-img img { max-height: 200px; }
            .cert-name { font-size: 1.15rem; }

            .section-header { margin-bottom: 35px; }
            .display-3 { font-size: 2rem; }
            .py-100 { padding: 50px 0; }

            .sector-tag { font-size: 11px; }
        }

        /* Mobile Portrait */
        @media (max-width: 576px) {
            .scroller-container { padding: 20px 0; }
            .scroller-track { gap: 12px; }
            .stock-card {
                width: 220px; padding: 18px;
                border-radius: 24px;
            }
            .card-header-icon { width: 45px; height: 45px; font-size: 0.8rem; }
            .price-val { font-size: 1.3rem; }
            .p-change { font-size: 0.8rem; }

            .large-scroller { padding: 20px 0; margin-top: 30px; }
            .scrolling-text { font-size: 2.5rem; }

            .cert-canvas {
                padding: 14px; min-height: 320px;
                border-radius: 28px;
            }
            .cert-img { height: 180px; }
            .cert-img img { max-height: 160px; }
            .cert-name { font-size: 1.05rem; }

            .section-header { margin-bottom: 30px; }
            .display-3 { font-size: 1.9rem; }
            .py-100 { padding: 40px 0; }

            .sector-tag { font-size: 10px; letter-spacing: 1px; }
            .btn-trade { padding: 16px 35px; font-size: 0.95rem; }

            /* Ensure no horizontal scroll */
            body { overflow-x: hidden; }
            .container { padding-left: 15px; padding-right: 15px; }
        }

        /* Extra Small Mobile */
        @media (max-width: 480px) {
            .stock-card { width: 200px; padding: 15px; }
            .card-header-icon { width: 40px; height: 40px; font-size: 0.75rem; }
            .price-val { font-size: 1.2rem; }
            .p-change { font-size: 0.75rem; }

            .scrolling-text { font-size: 2rem; }

            .cert-canvas { padding: 12px; min-height: 300px; }
            .cert-img { height: 160px; }
            .cert-img img { max-height: 140px; }
            .cert-name { font-size: 1rem; }

            .display-3 { font-size: 1.8rem; }
            .btn-trade { padding: 15px 30px; font-size: 0.9rem; }

            .container { padding-left: 10px; padding-right: 10px; }
        }

        /* Touch devices: Remove hover effects and add touch-friendly interactions */
        @media (hover: none) and (pointer: coarse) {
            .stock-card:hover { transform: none; }
            .cert-canvas:hover { transform: none; }
            .stock-card:active { transform: scale(0.98); }
            .cert-canvas:active { transform: scale(0.98); }
        }

        /* Desktop Enhancements */
        @media (min-width: 1200px) {
            .scroller-track { gap: 40px; }
            .stock-card { width: 320px; padding: 30px; }

            .cert-canvas { padding: 25px; min-height: 450px; }
            .cert-img { height: 300px; }
            .cert-img img { max-height: 280px; }
        }

        /* Ultra-wide screens */
        @media (min-width: 1400px) {
            .scroller-track { gap: 50px; }
            .stock-card { width: 350px; padding: 35px; }
            .cert-canvas { padding: 30px; min-height: 480px; }
            .cert-img { height: 320px; }
            .cert-img img { max-height: 300px; }
        }

        .btn-trade {
            background: #fff; color: #000; font-weight: 800; padding: 18px 50px;
            border-radius: 100px; text-decoration: none; display: inline-block;
        }

        /* Navbar integration */
        .navbar-fixed {
            position: fixed; top: 0; left: 0; width: 100%; z-index: 1000;
            background: rgba(5, 5, 5, 0.9); backdrop-filter: blur(10px);
            border-bottom: 1px solid var(--border);
        }

        .navbar-fixed .navbar-brand {
            color: var(--accent-green); font-weight: 800; font-size: 1.2rem;
        }

        .navbar-fixed .navbar-toggler {
            border: none; color: #fff;
        }

        .brand-font {
            font-family: 'Syne', sans-serif;
        }
    </style>
</head>
<body>
    <?php include 'includes/navbar.php'; ?>

    <div class="aura-bg"></div>

    <!-- Header Section -->
    <div class="container py-5 mt-5">
        <header class="section-header">
            <span class="sector-tag">About Our Platform</span>
            <h1 class="display-3 fw-bolder mt-3 brand-font">বিশ্বস্ত শিল্প গোষ্ঠীর <br><span style="color:var(--accent-green)">স্মার্ট ট্রেডিং পোর্টাল</span></h1>
        </header>
    </div>

    <!-- SIDE MOVING CARDS SECTION -->
    <div class="scroller-container">
        <div class="scroller-track">
            <!-- কার্ডসমূহ ২বার দেয়া হয়েছে লুপ ঠিক রাখার জন্য -->
            <!-- GP -->
            <div class="stock-card">
                <span class="sector-tag">টেলিকম</span>
                <div class="card-header-icon">GP</div>
                <h6>গ্রামীণফোন লি:</h6>
                <div class="price-val">৳৩২৬.৪০</div>
                <span class="p-change p-up"><i class="fas fa-arrow-up"></i> +১.৪%</span>
            </div>
            <!-- Square Pharma -->
            <div class="stock-card">
                <span class="sector-tag">ফার্মা</span>
                <div class="card-header-icon">SQ</div>
                <h6>স্কয়ার ফার্মা</h6>
                <div class="price-val">৳২১৫.২০</div>
                <span class="p-change p-up"><i class="fas fa-arrow-up"></i> +০.৬৫%</span>
            </div>
            <!-- BATBC -->
            <div class="stock-card">
                <span class="sector-tag">কনজিউমার</span>
                <div class="card-header-icon">BAT</div>
                <h6>বিএপিবিসি (তামাক)</h6>
                <div class="price-val">৳৫১৮.৯০</div>
                <span class="p-change p-down"><i class="fas fa-arrow-down"></i> -০.২%</span>
            </div>
            <!-- Walton -->
            <div class="stock-card">
                <span class="sector-tag">ইলেকট্রনিক্স</span>
                <div class="card-header-icon">WLT</div>
                <h6>ওয়ালটন হাই-টেক</h6>
                <div class="price-val">৳৬৫২.১০</div>
                <span class="p-change p-up"><i class="fas fa-arrow-up"></i> +৩.২%</span>
            </div>
            <!-- Robi -->
            <div class="stock-card">
                <span class="sector-tag">টেলিকম</span>
                <div class="card-header-icon">ROBI</div>
                <h6>রবি আজিয়াটা</h6>
                <div class="price-val">৳৩০.৫০</div>
                <span class="p-change p-up"><i class="fas fa-arrow-up"></i> +০.১%</span>
            </div>
             <!-- Bank Card -->
             <div class="stock-card">
                <span class="sector-tag">ব্যাংকিং</span>
                <div class="card-header-icon">BRAC</div>
                <h6>ব্র্যাক ব্যাংক</h6>
                <div class="price-val">৳৩৮.৪০</div>
                <span class="p-change p-up"><i class="fas fa-arrow-up"></i> +০.৫%</span>
            </div>
             <!-- Berger Paints -->
             <div class="stock-card">
                <span class="sector-tag">পেইন্টস</span>
                <div class="card-header-icon">BGR</div>
                <h6>বার্জার পেইন্টস</h6>
                <div class="price-val">৳১৭১৮.০</div>
                <span class="p-change p-up"><i class="fas fa-arrow-up"></i> +০.৮%</span>
            </div>

            <!-- লুপের সুবিধার জন্য পুনরায় কার্ডসমূহ কপি -->
            <div class="stock-card"> <span class="sector-tag">টেলিকম</span> <div class="card-header-icon">GP</div> <h6>গ্রামীণফোন লি:</h6> <div class="price-val">৳৩২৭.০০</div> <span class="p-change p-up">+১.৪%</span></div>
            <div class="stock-card"> <span class="sector-tag">ফার্মা</span> <div class="card-header-icon">SQ</div> <h6>স্কয়ার ফার্মা</h6> <div class="price-val">৳২১৫.২০</div> <span class="p-change p-up">+০.৬৫%</span></div>
            <div class="stock-card"> <span class="sector-tag">বিদ্যুৎ</span> <div class="card-header-icon">UPG</div> <h6>UPGDCL</h6> <div class="price-val">৳২৩৪.৩০</div> <span class="p-change p-up">+২.৪%</span></div>
            <div class="stock-card"> <span class="sector-tag">ইন্ডাস্ট্রি</span> <div class="card-header-icon">BEX</div> <h6>বেক্সিমকো গ্রুপ</h6> <div class="price-val">৳১১৫.১০</div> <span class="p-change p-down">-০.৮%</span></div>
            <div class="stock-card"> <span class="sector-tag">টেলিকম</span> <div class="card-header-icon">ROBI</div> <h6>রবি আজিয়াটা</h6> <div class="price-val">৳৩০.৫০</div> <span class="p-change p-up">+০.১%</span></div>
            <div class="stock-card"> <span class="sector-tag">পেইন্টস</span> <div class="card-header-icon">BGR</div> <h6>বার্জার পেইন্টস</h6> <div class="price-val">৳১৭৩০.০</div> <span class="p-change p-up">+০.৮%</span></div>
        </div>
    </div>

    <!-- LARGE CORPORATE NAMES SCROLLER (Infinite Move) -->
    <div class="large-scroller mt-5">
        <div class="scrolling-text">
            BASUNDHARA GROUP • AKIJ GROUP • S ALAM GROUP • CITY GROUP • PRAN RFL GROUP • BEXIMCO GROUP • BASHUNDHARA GROUP • AKIJ GROUP •
        </div>
    </div>

    <!-- CERTIFICATES (Dynamic from Admin/Settings) -->
    <section class="container py-100 mt-5 pt-5 mb-5">
        <div class="text-center mb-5">
            <span class="sector-tag">Verified Platform</span>
            <h2 class="display-5 fw-bold brand-font">আমাদের সকল আইনগত সনদ</h2>
        </div>

        <div class="row g-5">
            <?php
            $private_limited_cert = get_setting('private_limited_cert');
            $trade_license_cert = get_setting('trade_license_cert');
            $tin_cert = get_setting('tin_cert');

            $certificates = [
                [
                    'file' => $private_limited_cert,
                    'name' => 'Private Limited Company',
                    'description' => 'কোম্পানি রেজিস্ট্রেশন এবং আইনগত স্বীকৃতি'
                ],
                [
                    'file' => $trade_license_cert,
                    'name' => 'Trade License',
                    'description' => 'ব্যবসায়িক লাইসেন্স এবং ট্রেড পারমিট'
                ],
                [
                    'file' => $tin_cert,
                    'name' => 'TIN Certificate',
                    'description' => 'ট্যাক্স আইডেন্টিফিকেশন নম্বর এবং কর সনদ'
                ]
            ];

            foreach ($certificates as $index => $cert):
                if ($cert['file']):
            ?>
            <div class="col-lg-4 col-md-6 reveal-box">
                <div class="cert-canvas">
                    <div class="cert-img">
                        <?php
                        $file_ext = strtolower(pathinfo($cert['file'], PATHINFO_EXTENSION));
                        if (in_array($file_ext, ['jpg', 'jpeg', 'png'])) {
                            echo '<img src="uploads/certificates/' . htmlspecialchars($cert['file']) . '" alt="' . htmlspecialchars($cert['name']) . '" style="width: 90%; height: auto; border-radius: 15px;">';
                        } else {
                            echo '<div class="pdf-placeholder">
                                    <i class="fas fa-file-pdf fa-3x" style="color: #ff4444;"></i>
                                    <a href="uploads/certificates/' . htmlspecialchars($cert['file']) . '" target="_blank" class="btn btn-sm btn-outline-light mt-2">
                                        <i class="fas fa-external-link-alt"></i> PDF দেখুন
                                    </a>
                                  </div>';
                        }
                        ?>
                    </div>
                    <div class="cert-name"><?php echo htmlspecialchars($cert['name']); ?></div>
                    <p class="text-white-50 small p-3"><?php echo htmlspecialchars($cert['description']); ?></p>
                </div>
            </div>
            <?php
                endif;
            endforeach;
            ?>
        </div>

        <?php if (!$private_limited_cert && !$trade_license_cert && !$tin_cert): ?>
        <div class="text-center">
            <p class="text-white-50">কোনো সার্টিফিকেট আপলোড করা হয়নি। অ্যাডমিন প্যানেল থেকে সার্টিফিকেট আপলোড করুন।</p>
        </div>
        <?php endif; ?>
    </section>

    <!-- Detailed Site Info -->
    <section class="container py-5 mt-5 border-top border-secondary text-center">
        <div class="row">
            <div class="col-md-8 mx-auto">
                <h3 class="fw-bold mb-4 brand-font">কেন আমাদের বেছে নিবেন?</h3>
                <p class="text-white-50 lh-lg">আমরা নিয়ে এসেছি সরাসরি বড় শিল্প গোষ্ঠীর স্টক সরাসরি কেনাবেচার সুবিধা। আপনার নিরাপত্তা আমাদের প্রধান অঙ্গীকার। আধুনিক অ্যানালিটিক্স এবং রিয়েল-টাইম মার্কেট ডেটার মাধ্যমে আপনি হতে পারবেন এক নির্ভুল বিনিয়োগকারী। গ্রামীণফোন থেকে শুরু করে প্রাণের মতো বড় বড় প্রতিষ্ঠানে আপনার পুঁজি রাখুন সম্পূর্ণ নিরাপদ পরিবেশে।</p>
                <div class="mt-4"><a href="<?php echo is_logged_in() ? 'dashboard.php' : 'index.php'; ?>" class="btn-trade">এখনই একাউন্ট খুলুন</a></div>
            </div>
        </div>
    </section>

    <footer class="text-center py-5 opacity-25 mt-5">
        <p>© ২০২৪ । সকল বিনিয়োগই ঝুঁকি সাপেক্ষ। নিয়ম মেনে বিনিয়োগ করুন।</p>
    </footer>

    <!-- Animations Library -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/gsap.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/gsap/3.12.2/ScrollTrigger.min.js"></script>
    <script src="assets/js/dashboard.js"></script>

    <script>
        gsap.registerPlugin(ScrollTrigger);

        // Entrance animation
        gsap.from(".brand-font", { duration: 1.5, opacity: 0, y: 50, ease: "power4.out" });

        // Certificate box reveals
        gsap.from(".reveal-box", {
            scrollTrigger: {
                trigger: ".reveal-box",
                start: "top 80%"
            },
            y: 80, opacity: 0, stagger: 0.2, duration: 1, ease: "expo.out"
        });

        // Extra polish: Pause and slowdown handle on scrolling behavior
    </script>
</body>
</html>
