# বাংলা ইনভেস্টমেন্ট প্ল্যাটফর্ম

একটি সম্পূর্ণ PHP-ভিত্তিক বাংলা ভাষায় শেয়ার বাজার বিনিয়োগ প্ল্যাটফর্ম। মোবাইল-ফ্রেন্ডলি ডিজাইন, অ্যাডমিন প্যানেল, এবং সমস্ত প্রয়োজনীয় ফিচার সহ।

## 🚀 প্রধান ফিচারস

### 👤 ইউজার ফিচারস
- ✅ রেজিস্ট্রেশন এবং লগইন
- ✅ বিনিয়োগ (সাধারণ/মাস্টার ক্যাটাগরি)
- ✅ ডিপোজিট এবং উইথড্রয়াল
- ✅ ব্যালেন্স ম্যানেজমেন্ট
- ✅ রেফারেল সিস্টেম
- ✅ ট্রানজেকশন হিস্টরি
- ✅ ভিডিও টিউটোরিয়ালস

### 👨‍💼 অ্যাডমিন ফিচারস
- ✅ ট্রানজেকশন ম্যানেজমেন্ট (অনুমোদন/প্রত্যাখ্যান)
- ✅ ইউজার ম্যানেজমেন্ট
- ✅ কোম্পানি ম্যানেজমেন্ট
- ✅ সিস্টেম স্ট্যাটিসটিকস

## 🛠️ ইনস্টলেশন এবং সেটআপ

### ১. প্রয়োজনীয়তা
- PHP 7.4+
- MySQL 5.7+
- Apache/Nginx ওয়েব সার্ভার
- XAMPP/LAMP/WAMP (ডেভেলপমেন্টের জন্য)

### ২. ডাটাবেস সেটআপ
```bash
# phpMyAdmin এ যান
# 'investment_platform' নামে নতুন ডাটাবেস তৈরি করুন
# database/schema.sql ফাইল ইমপোর্ট করুন
```

### ৩. কনফিগারেশন
`includes/config.php` ফাইলে ডাটাবেস তথ্য আপডেট করুন:
```php
define('DB_HOST', 'localhost');
define('DB_USER', 'your_username');
define('DB_PASS', 'your_password');
define('DB_NAME', 'investment_platform');
```

### ৪. ফাইল পারমিশন
```bash
chmod 755 logs/
chmod 644 logs/*.log
```

### ৫. ক্রন জব সেটআপ (ডেইলি প্রফিট প্রসেসিং)
```bash
# লিনাক্স/ম্যাক এ:
crontab -e
# এই লাইন যোগ করুন (প্রতি দিন রাত ২টায়):
0 2 * * * /usr/bin/php /path/to/project/cron/process_profits.php

# উইন্ডোজ টাস্ক স্কেডিউলার ব্যবহার করুন
```

## 📁 প্রজেক্ট স্ট্রাকচার

```
investment-platform/
├── api/                    # AJAX API এন্ডপয়েন্টস
│   ├── login.php
│   ├── register.php
│   ├── invest.php
│   ├── deposit.php
│   ├── withdrawal.php
│   ├── get_transactions.php
│   └── ...
├── admin/                  # অ্যাডমিন প্যানেল
│   ├── index.php          # অ্যাডমিন লগইন
│   ├── dashboard.php      # অ্যাডমিন ড্যাশবোর্ড
│   ├── login.php          # অ্যাডমিন লগইন API
│   ├── logout.php         # অ্যাডমিন লগআউট
│   └── api/               # অ্যাডমিন API
│       ├── approve_transaction.php
│       └── reject_transaction.php
├── assets/                 # CSS, JS, ছবি
│   ├── css/
│   │   └── style.css
│   └── js/
│       ├── script.js
│       ├── dashboard.js
│       ├── deposit.js
│       ├── withdrawal.js
│       ├── transaction.js
│       ├── referral.js
│       ├── help.js
│       └── admin.js
├── cron/                   # ক্রন জব ফাইলস
│   └── process_profits.php
├── database/               # ডাটাবেস স্কিমা
│   └── schema.sql
├── includes/               # কমন ফাইলস
│   ├── config.php
│   └── functions.php
├── logs/                   # লগ ফাইলস
├── index.php              # হোমপেজ
├── dashboard.php          # ইউজার ড্যাশবোর্ড
├── deposit.php            # ডিপোজিট পেজ
├── withdrawal.php         # উইথড্রয়াল পেজ
├── history.php            # বিনিয়োগ হিস্টরি
├── transaction.php        # ট্রানজেকশন হিস্টরি
├── referral.php           # রেফারেল পেজ
├── profile.php            # প্রোফাইল পেজ
├── help.php               # হেল্প & সাপোর্ট
├── about.php              # কোম্পানি সম্পর্কে
├── policy.php             # নীতিমালা
├── logout.php             # লগআউট
└── README.md
```

## 🔐 লগইন তথ্য

### অ্যাডমিন লগইন
- **ইমেইল:** admin@admin.com
- **পাসওয়ার্ড:** admin123
- **লিংক:** `admin/index.php?admin=login`

### টেস্ট ইউজার তৈরি
প্রথমে `index.php` তে গিয়ে রেজিস্টার করুন।

## 🎯 ব্যবহার নির্দেশনা

### ১. ইউজার হিসেবে
1. `index.php` তে রেজিস্টার/লগইন করুন
2. `dashboard.php` এ বিনিয়োগ ক্যাটাগরি সিলেক্ট করুন
3. কোম্পানি চয়েস করে বিনিয়োগ করুন
4. `deposit.php` তে ব্যালেন্স যোগ করুন
5. `withdrawal.php` তে টাকা উত্তোলন করুন

### ২. অ্যাডমিন হিসেবে
1. `admin/index.php?admin=login` এ লগইন করুন
2. `admin/dashboard.php` এ ট্রানজেকশন ম্যানেজ করুন
3. ইউজার ডিপোজিট/উইথড্রয়াল অনুমোদন/প্রত্যাখ্যান করুন

## 💾 ডাটাবেস টেবলস

- **users** - ইউজার তথ্য
- **companies** - কোম্পানি তথ্য
- **investments** - বিনিয়োগ রেকর্ড
- **transactions** - সকল ট্রানজেকশন
- **notices** - নোটিস/বিজ্ঞপ্তি
- **payment_methods** - পেমেন্ট মেথডস
- **referral_settings** - রেফারেল কনফিগারেশন
- **referral_history** - রেফারেল হিস্টরি
- **videos** - টিউটোরিয়াল ভিডিওস
- **settings** - সিস্টেম সেটিংস

## 🔧 API এন্ডপয়েন্টস

### ইউজার API
- `POST /api/login.php` - লগইন
- `POST /api/register.php` - রেজিস্ট্রেশন
- `POST /api/invest.php` - বিনিয়োগ
- `POST /api/deposit.php` - ডিপোজিট
- `POST /api/withdrawal.php` - উইথড্রয়াল
- `GET /api/get_transactions.php` - ট্রানজেকশন লিস্ট
- `GET /api/get_investments.php` - বিনিয়োগ লিস্ট

### অ্যাডমিন API
- `GET /admin/api/approve_transaction.php?id=X` - ট্রানজেকশন অনুমোদন
- `GET /admin/api/reject_transaction.php?id=X` - ট্রানজেকশন প্রত্যাখ্যান

## ⚙️ কনফিগারেশন সেটিংস

`settings` টেবলে নিম্নলিখিত কীগুলো কনফিগার করা যায়:
- `company_name` - কোম্পানির নাম
- `min_deposit` - সর্বনিম্ন ডিপোজিট
- `max_deposit` - সর্বোচ্চ ডিপোজিট
- `min_withdrawal` - সর্বনিম্ন উইথড্রয়াল
- `withdrawal_fee` - উইথড্রয়াল ফি

## 🔒 নিরাপত্তা

- পাসওয়ার্ড হ্যাশিং (bcrypt)
- SQL ইনজেকশন প্রতিরোধ (Prepared Statements)
- XSS প্রতিরোধ (Input Sanitization)
- CSRF প্রতিরোধ (Session Tokens)

## 📱 রেসপন্সিভ ডিজাইন

- Bootstrap 5 ফ্রেমওয়ার্ক
- মোবাইল-প্রায়োরিটি ডিজাইন
- কাস্টম CSS অ্যানিমেশন
- ফন্ট: Noto Sans Bengali

## 🆘 সাপোর্ট

প্রজেক্টটি সম্পূর্ণ ওপেন সোর্স। যেকোনো সমস্যায় ইস্যু তৈরি করুন বা কন্ট্রিবিউট করুন।

## 📄 লাইসেন্স

এই প্রজেক্টটি MIT লাইসেন্সের আওতায় রয়েছে।

---

**ডেভেলপড বাই:** AI Assistant
**তারিখ:** <?php echo date('d/m/Y'); ?>
**ভার্সন:** 1.0.0
